#include <BWAPI.h>
#include <fstream>
#include "BWEM/bwem.h"
#include "BWEB/BWEB.h"
#include "PathSearch.h"

using namespace std;
using namespace BWAPI;
using namespace UnitTypes;
auto &X = Broodwar;

#define C X->self()
#define XE X->enemy()
#define GC ->getClosestUnit
#define GR X->getUnitsInRadius
#define Q u->getType()
#define L(z)(z&&z->exists()&&z->isDetected())
#define B(z)Filter::Is##z
#define BE B(Enemy)
#define BM B(MineralField)
#define BO B(Owned)
#define BR B(ResourceDepot)
#define BW B(Worker)
#define FGT Filter::GetType
#define FCA Filter::CanAttack
#define PI 3.141592653589793238462643383279502884L

vector<string> hisInfo;
const int secondsPerTick = 10;
const int framesPerTick = secondsPerTick * 24;
const int numMyRecentStats = 20;
int myRecentStats[numMyRecentStats] = { 0 };
vector<UnitType> hisTypesToCheck;
int his1stCloakerFrame = 0;
map<Unit, Unit>q; // map of worker gather assignments
map<Unit, int> enemyUnitAndFrameAttackStarted; // map of latest frame when an enemy unit either attacked or a friendly unit started an attack
string enemyRace = "Unknown";
string enemyName;
BWEM::Map & bwemMapInstance = BWEM::Map::Instance();
int myScoutID = -99, myWatcherID = -99, myWatcherID2 = -99;
map<TilePosition, bool> myScoutTargetsAndStatus;
TilePosition hisMain = TilePositions::None;
vector<TilePosition> hisPossibleDs;
map<UnitType, int> myUnitsCreated;
map<UnitType, int> hisUnitsCreated;
bool hisMainKilled = false;
int myAttackStartedSince = 0;
Position myCP = Positions::None, myNatCP = Positions::None;
Position hisMainCenter = Positions::None, hisNatCenter = Positions::None;
int numStartingLocs = 0;
int	thisMapIndex = 999;
map<double, TilePosition>distsAndBases; // Used by `GetMyNaturalAndOtherBases(...) and search parties when his main is dead
int currentFrame;		// frame count
int cs;  // guard frame to avoid calling too many scouts
int myBO = 0; // my build order index
int hisBO = 0; // his build order index
int myBOStats[20] = { 0 }; // my build order stats
int myBOStatsSize = sizeof(myBOStats) / sizeof(myBOStats[0]);
int myBOStatsActual[20] = { 0 }; // when there are enough recent games, ditch `myBOStats`
TilePosition myMain, myNat, my3rd; // my start location, my nat location, my 3rd location
Position myMainCenter = Positions::None, myNatCenter = Positions::None, my3rdCenter = Positions::None;
Unit t; vector<Unit>m; // nullptr unit, queue of available gather targets (mineral patches and vespene geysers)
void o(Unit u) { m.insert(m.begin(), u); } // Add resources to gather
void p(TilePosition u) { for (Unit z : GR(Position(u) + Position(64, 48), 400, BM))o(z), o(z); } // add all mineral patches close to a position to the queue
void s(Unit u) { if (q[u])o(q[u]), q.erase(u); } // remove a worker from a gather assignment
int myBuilderID = 0;
TilePosition myBuildLoc = TilePositions::None;
int myStartingInd = 0;
int hisStartingInd = 0;
int myMaxCannons = 0;
vector<int> myFeasibleBOs = { 1, 2, 3, 4, 5, 6 };
int myTotalBOs = myFeasibleBOs.size();

char Num2Char(int num_in) {
	int num_33 = num_in + 33;

	if (num_33 >= 127) {
		if (num_33 <= 255) {
			switch (num_33) {
			case 127: num_33++; break;
			case 129: num_33++; break;
			case 141: num_33++; break;
			case 143: num_33 += 2; break;
			case 144: num_33++; break;
			case 157: num_33++; break;
			case 160: num_33++; break;
			default:;
			}
		}
		else num_33 = 255;
	}

	return static_cast<char>(num_33);
}

int CC(UnitType ut) { return C->completedUnitCount(ut); } // count my completed units
int CW(UnitType ut) { // count my units being warped
	int res = 0;
	for (Unit u : C->getUnits()) {
		if (Q.isBuilding())
			if (!u->isCompleted() && u->getBuildType() == ut
				|| !u->getTrainingQueue().empty() && ut.toString().compare(u->getTrainingQueue().begin()->getName()) == 0)
				res++;
	}
	return res;
}
int CL(UnitType ut) { return CC(ut) + CW(ut); } // count my total units (completed + being warped)

int DistSq2(const Position &pos1, const Position &pos2) {
	return(pos1.x - pos2.x) * (pos1.x - pos2.x) + (pos1.y - pos2.y) * (pos1.y - pos2.y);
} // DistSq2()

int GetAttackPriority(Unit u) {
	// Special cases
	if (Q == Zerg_Egg || Q == Zerg_Larva) return -1;

	// Everything else
	if (Q.groundWeapon() != WeaponTypes::None && !Q.isFlyer()) return 11; 	// highest priority is something that can attack us or aid in combat
	else if (Q.isSpellcaster() && !Q.isFlyer()) return 10;
	else if (Q.airWeapon() != WeaponTypes::None && !Q.isFlyer()) return 9;
	else if (Q.isWorker()) return 8;
	else if (Q.groundWeapon() != WeaponTypes::None && Q.isFlyer()) return 6;
	else if (Q.isRefinery() || Q == Protoss_Pylon) return 5;
	else if (Q.isResourceDepot()) return 4;
	else if (Q.gasPrice() > 0) return 3; // Buildings that cost gas
	else if (Q.mineralPrice() > 0) return 2;
	else if (Q.isNeutral()) return 1;
	else return 1;
} // GetAttackPriority

Unit FindTarget(Unit attacker)
{
	Position attackerPos = attacker->getPosition();
	UnitType attackerType = attacker->getType();
	int attackerRange = attackerType.sightRange();
	Unit target = NULL;

	Unitset nearbyEnemys = GR(attackerPos, 3 * attackerRange / 2, (BE || B(Neutral)) && !B(Invincible)); // Using minimum sight range as search radius; Working as intended

	int hightPriority = -99999;
	int lowHealth = 99999;

	for (auto u : nearbyEnemys)
	{
		if (!u->isDetected() && u->isVisible()) continue;
		if (attackerType.airWeapon() == WeaponTypes::None && (Q.isFlyer() || Q.isFlyingBuilding())) continue;
		if (attackerType.groundWeapon() == WeaponTypes::None && (!Q.isFlyer() && !Q.isFlyingBuilding())) continue;
		if (target != NULL && !Q.canAttack()) continue; //if has target, do not attack the building first

		int enemyPriority = GetAttackPriority(u);
		if (enemyPriority >= 0) {
			if (enemyPriority > hightPriority
				|| (enemyPriority == hightPriority && u->getHitPoints() < lowHealth)
				|| target == NULL)
			{
				hightPriority = enemyPriority;
				lowHealth = u->getHitPoints();
				target = u;
			}
		}
	}

	return target;
} // FindTarget()

void SmartMove(Unit attacker, Position targetPosition)
{
	if (attacker->getLastCommandFrame() >= currentFrame - 10) return; // if we have issued a command to this unit already this frame, ignore this one
	UnitCommand currentCommand(attacker->getLastCommand()); 	// get the unit's current command
	if ((currentCommand.getType() == UnitCommandTypes::Move) // if we've already told this unit to attack this target, ignore this command
		&& (currentCommand.getTargetPosition() == targetPosition)
		&& (currentFrame - attacker->getLastCommandFrame() < 10)
		&& (attacker->isMoving())) return;

	attacker->move(targetPosition); // if nothing prevents it, move to the target
} // SmartMove

void SmartAttack(Unit attacker, Unit target)
{
	if (attacker == NULL || target == NULL) return;

	// if we have issued a command to this unit already this frame, ignore this one
	//if (attacker->getLastCommandFrame() >= currentFrame - 5) return;

	// Data from: https://docs.google.com/spreadsheets/d/1bsvPvFil-kpvEUfSG74U3E5PLSTC02JxSkiR8QdLMuw/edit#gid=0

	UnitCommand currentCommand(attacker->getLastCommand()); // get the unit's current command
	
	if (attacker->getType() == Protoss_Reaver)
		if (attacker->getLastCommandFrame() >= currentFrame - 4
			|| currentCommand.getType() == UnitCommandTypes::Attack_Unit &&	currentCommand.getTarget() == target
			&& currentFrame - attacker->getLastCommandFrame() < 8) return;

	if (target->isFlying() && attacker->getAirWeaponCooldown() != 0 || !target->isFlying() && attacker->getGroundWeaponCooldown() != 0) return;

	if (currentCommand.getType() != UnitCommandTypes::Attack_Unit || currentCommand.getTarget() != target)
		attacker->attack(target); // if nothing prevents it, attack the target
} // SmartAttack

TilePosition FindBuildingPlacementAroundAPoint(UnitType buildingType, TilePosition searchCenter) {
	if (buildingType == Protoss_Nexus 
		&& (searchCenter == myNat
		&& X->getUnitsInRectangle(Position(myNat), Position(myNat + buildingType.tileSize()), B(Building)).empty()
			|| searchCenter == my3rd
			&& X->getUnitsInRectangle(Position(my3rd), Position(my3rd + buildingType.tileSize()), B(Building)).empty()))
		return myNat;

	int mapWidth = X->mapWidth();
	int mapHeight = X->mapHeight();
	TilePosition buildingSize = buildingType.tileSize();
	TilePosition mapCenter = TilePosition(mapWidth / 2, mapHeight / 2);

	for (int iRadius = 1; iRadius < 18; ++iRadius) {
		for (int idy = searchCenter.y - iRadius * buildingSize.y; idy <= searchCenter.y + iRadius * buildingSize.y; idy++) {
			for (int idx = searchCenter.x - iRadius * buildingSize.x; idx <= searchCenter.x + iRadius * buildingSize.x; idx++) {
				if (idy == searchCenter.y - iRadius * buildingSize.y
					|| idy == searchCenter.y + iRadius * buildingSize.y
					|| idx == searchCenter.x - iRadius * buildingSize.x
					|| idx == searchCenter.x + iRadius * buildingSize.x
					) // eliminate repeated calculation
					if (idx < mapWidth && idx > 0 && idy < mapHeight && idy > 0) // causes CRASH if coords are outside of the map!!!
					{
						TilePosition buildingTopLeft(idx, idy);
						TilePosition buildingBottomRight = buildingTopLeft + buildingSize;

						bool closerToCalibCenter = (searchCenter.x - idx) * (mapCenter.x - idx) < 0 && (searchCenter.y - idy) * (mapCenter.y - idy) < 0;
						bool freeFromMyNat = true;
						if (buildingType != Protoss_Nexus)
							if (idx + buildingSize.x + 2 > myNat.x && idx < myNat.x + 6
								&& idy + buildingSize.y + 2 > myNat.y && idy < myNat.y + 5)
								freeFromMyNat = false;

						if (X->canBuildHere(buildingTopLeft, buildingType) 
							&& closerToCalibCenter
							&& X->getUnitsInRectangle(Position(buildingTopLeft), Position(buildingBottomRight), B(Building)).empty()
							&& freeFromMyNat)
							return buildingTopLeft;
					}
			}
		}
	}

	// Resort to the vanilla finder if everything above fails
	return X->getBuildLocation(buildingType, searchCenter, 18);
} // TilePosition FindBuildingPlacementAroundAPoint(UnitType buildingType, TilePosition searchCenter)

void Warp(UnitType ut, TilePosition b0 = myMain, TilePosition z = myMain) { // b0: build location search center; z: builder search center
	//X << ut.toString() << endl;
	if (myBuildLoc == TilePositions::None
		|| !X->getUnitsInRectangle(Position(myBuildLoc), Position(myBuildLoc + TilePosition(ut.tileWidth(), ut.tileHeight())), BO && B(Building)).empty()
		) {
		TilePosition desiredTL = b0;
		if (ut != Protoss_Pylon && ut != Protoss_Assimilator && ut != Protoss_Nexus)
			for (Unit iPylon : C->getUnits())
				if (L(iPylon) && iPylon->isCompleted() && iPylon->getType() == Protoss_Pylon)
				{
					desiredTL = iPylon->getTilePosition();
					break;
				}

		myBuildLoc = FindBuildingPlacementAroundAPoint(ut, desiredTL);
	}

	if (ut == Protoss_Nexus) myBuildLoc = b0;
	if (ut == Protoss_Pylon) {
		if (myBuildLoc != TilePositions::None)
			for (TilePosition nexusTL : {myNat, my3rd})
				if (myBuildLoc.x + 3 > nexusTL.x && myBuildLoc.x < nexusTL.x + 5
					&& myBuildLoc.y + 3 > nexusTL.y && myBuildLoc.y < nexusTL.y + 4) {
					myBuildLoc = FindBuildingPlacementAroundAPoint(ut, myMain);
					return;
				}
	}

	if (myBuildLoc != TilePositions::None) {
		//X << "myBuildLoc found!" << endl;
		//X->drawBoxMap(Position(myBuildLoc), Position(myBuildLoc + TilePosition(ut.tileWidth(), ut.tileHeight())), Colors::Blue, true);
		
		// Find builder
		Unit br = NULL;

		if (myBuilderID == 0
			|| none_of(C->getUnits().begin(), C->getUnits().end(), [](Unit u1) { return u1->isCompleted() && u1->getType() == Protoss_Probe && u1->getID() == myBuilderID; })
			)
		{
			Unit br = X GC(Position(myBuildLoc), BO && BW && (B(Idle) || B(GatheringMinerals)) && !B(CarryingGas) && !B(CarryingMinerals) && !B(GatheringGas), 24 * 32);

			if (!L(br)) br = X GC(Position(z), BO && BW && (B(Idle) || B(GatheringMinerals)) && !B(CarryingGas) && !B(CarryingMinerals) && !B(GatheringGas), 24 * 32);

			if (L(br)) myBuilderID = br->getID();
		}
		else {
			for (auto u2 : C->getUnits())
				if (u2->isCompleted() && u2->getType() == Protoss_Probe && u2->getID() == myBuilderID)
				{
					br = u2; break;
				}
		}

		// Build
		if (L(br)) {
			Position myBuildCenter = (Position(myBuildLoc) + Position(myBuildLoc + TilePosition(ut.tileWidth(), ut.tileHeight()))) / 2;

			if (DistSq2(br->getPosition(), myBuildCenter) > 9000) {
				SmartMove(br, myBuildCenter);
			}
			else {
				if (C->minerals() < ut.mineralPrice() || C->gas() < ut.gasPrice())
				{
					if (!br->isHoldingPosition()) br->holdPosition();
				}
				else if (br->getLastCommand().getType() != UnitCommandTypes::Build || currentFrame - br->getLastCommandFrame() > 120) {
					br->build(ut, myBuildLoc);
				}
			}
		}
	}
} // Construct a building around b0 choosing a worker near z

TilePosition FindNatPos(BWEM::Map & mapBWEM, TilePosition basePos) {
	int distBest = 99999;
	TilePosition cand = TilePositions::None;

	for (auto &area : mapBWEM.Areas()) {
		if (area.AccessibleNeighbours().empty()) continue;
		for (auto &base : area.Bases()) {
			// Must have gas, be accesible and at least 5 mineral patches
			if (base.Geysers().empty() || base.Minerals().size() < 5) continue;

			int dist = static_cast<int>(BWEB::Map::getGroundDistance(base.Center(), Position(basePos) + Position(64, 48)));
			if (dist < distBest && !base.Starting() && base.Location() != basePos && base.Location() != myNat) {
				distBest = dist;
				cand = base.Location();
			}
		}
	}

	return cand;
} // TilePosition FindNatPos(...)

void GetMyNaturalAndOtherBases(BWEM::Map & mapBWEM) {
	auto distBest = DBL_MAX;
	auto distBestMain = DBL_MAX;
	TilePosition closestMain = TilePositions::None;

	for (auto &area : mapBWEM.Areas()) {
		if (area.AccessibleNeighbours().empty()) continue;
		for (auto &base : area.Bases()) {
			// Must have gas, be accesible and at least 5 mineral patches
			if (base.Geysers().empty() || base.Minerals().size() < 5) continue;
			
			const auto dist = BWEB::Map::getGroundDistance(base.Center(), myMainCenter);
			distsAndBases[dist] = base.Location();
			if (dist < distBest && !base.Starting()) {
				distBest = dist;
				myNat = base.Location();
			}

			if (dist < distBestMain && base.Starting() && base.Location() != myMain) {
				distBestMain = dist;
				closestMain = base.Location();
			}
		}
	}
	distsAndBases.erase(distsAndBases.find(distBest)); // Exclude my natural
	distsAndBases.erase(distsAndBases.find(0.0)); // Exclude my starting main
	if (X->getStartLocations().size() == 2)
		hisMain = closestMain;

	my3rd = distsAndBases.begin()._Ptr->_Myval.second;

	// Map-specific adjustment
	if (thisMapIndex == 0) { // Benzene: avoid pathfinding problems caused by the power generators
		if (myStartingInd == 1) my3rd = TilePosition(75, 103); // TilePosition(80, 5);
		else my3rd = TilePosition(49, 5); // TilePosition(44, 103);
	}
	else if (thisMapIndex == 2) { // HBR: avoid getting the 3rd in the map center
		if (myStartingInd == 21) my3rd = TilePosition(8, 5);
		else my3rd = TilePosition(116, 87);
	}

	myNatCenter = Position(myNat) + Position(64, 48);
	my3rdCenter = Position(my3rd) + Position(64, 48);
} // void GetMyNaturalAndOtherBases(...)

void GoScouting(Unit u) {
	if (Q == Protoss_Probe) { // Workers return resource first..
		if (u->isCarryingGas() || u->isCarryingMinerals()) {
			if (u->getLastCommand().getType() != UnitCommandTypes::Return_Cargo) u->returnCargo();
			return;
		}
	}

	if (hisMain == TilePositions::None && hisPossibleDs.size() == 1) hisMain = hisPossibleDs.front();

	for (TilePosition sl : X->getStartLocations()) {
		if (sl == myMain) continue;

		Position slPos = Position(sl);

		bool hisMainFound = false;

		if (!GR(slPos, 12 * 32, BE && B(Building)).empty()) hisMainFound = true;

		if (TilePosition thisNatPos = FindNatPos(bwemMapInstance, sl))
			if (!GR(Position(thisNatPos), (numStartingLocs == 4 ? 14 : 9) * 32, BE && B(Building)).empty())
				hisMainFound = true;

		if (hisMainFound) {
			if (hisMain == TilePositions::None) hisMain = sl;
			myScoutTargetsAndStatus[sl] = true;

			if (Q == Protoss_Probe)
				if (Unit cm = X GC(myMainCenter, BM, 7 * 32))
					u->gather(cm); return;

			break;
		}

		if (!myScoutTargetsAndStatus[sl]) { // not visited yet
			if (DistSq2(slPos, u->getPosition()) < 50176 && GR(slPos, 224, BE && !BW).empty()) {
				if (hisPossibleDs.size() >= 2)
					hisPossibleDs.erase(remove(hisPossibleDs.begin(), hisPossibleDs.end(), sl), hisPossibleDs.end());

				myScoutTargetsAndStatus[sl] = true; continue;
			}
			else if (DistSq2(slPos, u->getPosition()) >= 50176) { SmartMove(u, slPos); return; }
		}
	}
}

struct UnitInfo {
	UnitType unitType;
	Position unitPos;
	int unitEHP;
	pair<double, double> unitSpd;
	int lastFrameVisible;
};
map<int, UnitInfo> hisUnitIDAndInfo = {};
map<UnitType, int> hisDeadUnits = {};
map<pair<UnitType, UnitType>, double> unitMatchupCost = {
	{ make_pair(Protoss_Zealot, Protoss_Photon_Cannon), .33 },
	{ make_pair(Protoss_Dragoon, Protoss_Photon_Cannon), .33 },
	{ make_pair(Protoss_Dark_Templar, Protoss_Photon_Cannon), .5 },
	{ make_pair(Protoss_Archon, Protoss_Photon_Cannon), 1.0 },
	{ make_pair(Protoss_Reaver, Protoss_Photon_Cannon), 1.0 },
	{ make_pair(Protoss_Zealot, Terran_Bunker), .25 },
	{ make_pair(Protoss_Dragoon, Terran_Bunker), .25 },
	{ make_pair(Protoss_Dark_Templar, Terran_Bunker), .33 },
	{ make_pair(Protoss_Archon, Terran_Bunker), .5 },
	{ make_pair(Protoss_Reaver, Terran_Bunker), 1.0 },
	{ make_pair(Protoss_Zealot, Zerg_Sunken_Colony), .25 },
	{ make_pair(Protoss_Dragoon, Zerg_Sunken_Colony), .25 },
	{ make_pair(Protoss_Dark_Templar, Zerg_Sunken_Colony), .33 },
	{ make_pair(Protoss_Archon, Zerg_Sunken_Colony), .5 },
	{ make_pair(Protoss_Reaver, Zerg_Sunken_Colony), 1.0 }
};

int CountHisUnits(UnitType ut) {
	int res = 0;
	for (auto u : hisUnitIDAndInfo) {
		if (u.second.unitType == ut)
			res++;
	}
	return res;
}

int EffectivePrice(UnitType ut) {
	if (ut == Protoss_Photon_Cannon) return 300;
	else if (ut == Zerg_Zergling) return ut.mineralPrice() / 2;
	else if (ut == Terran_Bunker) return 300;
	else if (ut == Zerg_Sunken_Colony) return 300;

	return ut.mineralPrice() + ut.gasPrice();
}

UnitType GetThreatType(int opMode = 1) {
	if (opMode == 1) { // Anti-ground-unit defensive buildings
		if (enemyRace.compare("_P") == 0) return Protoss_Photon_Cannon;
		else if (enemyRace.compare("_T") == 0) return Terran_Bunker;
		else if (enemyRace.compare("_Z") == 0) return Zerg_Sunken_Colony;
	}
	else if (opMode == 2) { // Anti-air defensive buildings
		if (enemyRace.compare("_P") == 0) return Protoss_Photon_Cannon;
		else if (enemyRace.compare("_T") == 0) return Terran_Bunker;
		else if (enemyRace.compare("_Z") == 0) return Zerg_Spore_Colony;
	}
	else if (opMode == 3) { // Anti-air ground units
		if (enemyRace.compare("_P") == 0) return Protoss_Dragoon;
		else if (enemyRace.compare("_T") == 0) return Terran_Marine;
		else if (enemyRace.compare("_Z") == 0) return Zerg_Hydralisk;
	}
	else if (opMode == 4) { // Anti-air ground units (high tech)
		if (enemyRace.compare("_P") == 0) return Protoss_Archon;
		else if (enemyRace.compare("_T") == 0) return Terran_Goliath;
	}
	else if (opMode == 5) { // Dual-purpose air units
		if (enemyRace.compare("_P") == 0) return Protoss_Scout;
		else if (enemyRace.compare("_T") == 0) return Terran_Wraith;
		else if (enemyRace.compare("_Z") == 0) return Zerg_Mutalisk;
	}
	else if (opMode == 6) { // Anti-air air units
		if (enemyRace.compare("_P") == 0) return Protoss_Corsair;
		else if (enemyRace.compare("_T") == 0) return Terran_Valkyrie;
		else if (enemyRace.compare("_Z") == 0) return Zerg_Scourge;
	}
	else if (opMode == 7) { // Dual-purpose air units (high tech)
		if (enemyRace.compare("_P") == 0) return Protoss_Carrier;
		else if (enemyRace.compare("_T") == 0) return Terran_Battlecruiser;
		else if (enemyRace.compare("_Z") == 0) return Zerg_Devourer;
	}

	return UnitTypes::None;
}

void UpdateAttackInfo(int opMode) {
	if (opMode <= 4 || opMode == 6) {
		UnitType threatType = GetThreatType();
		
		// Get `myAttackStartedSince`
		if (CC(Protoss_Reaver)) myAttackStartedSince = currentFrame;
		else {
			if (CountHisUnits(threatType)) {
				double myDivers = 0.0;
				double hisActualThreats = 0.0;
				double myActualDivers = 0.0;
				map<UnitType, double> GetMaxEHP = { 
					{ Protoss_Zealot, 160.0},
					{ Protoss_Dragoon, 180.0},
					{ Protoss_Dark_Templar, 120.0 } };
				double threatEHP = threatType.maxHitPoints() + threatType.maxShields();

				for (Unit u : C->getUnits()) {
					if (u->isCompleted() && (Q == Protoss_Zealot || Q == Protoss_Dragoon || Q == Protoss_Dark_Templar)) {
						Position uPos = u->getPosition();

						double hisActualThreatsDelta = 0.0;
						for (auto u1 : hisUnitIDAndInfo)
							if (u1.second.unitType == threatType && DistSq2(u1.second.unitPos, uPos) <= 324 * 1024)
								hisActualThreatsDelta += u1.second.unitEHP / threatEHP;

						if (hisActualThreatsDelta) {
							myDivers += unitMatchupCost[make_pair(Q, threatType)] * (u->getHitPoints() + u->getShields()) / GetMaxEHP[Q];
							myActualDivers += 1.0;
							hisActualThreats += hisActualThreatsDelta;
						}
					}
				}

				if (myActualDivers && myDivers > hisActualThreats / myActualDivers) 
					myAttackStartedSince = currentFrame; 
			} // if he has `threatType`
		} // no reaver
	} // opMode == 1
	else if (opMode == 5) {
		if (any_of(C->getUnits().begin(), C->getUnits().end(), [](Unit u1) {
			return u1->isCompleted() && u1->isUnderAttack() && u1->getType().isBuilding(); })
			|| !GR(myMainCenter, 7 * 32, BE && !BW && FCA && !B(Flying)).empty())
		{
			myAttackStartedSince = currentFrame; return;
		}

		Position hisLeaderPos = Positions::None;
		double bestDist = 99999.9;
		Position zeroPos = Position(0, 0);

		// Get his army leader
		for (auto u : hisUnitIDAndInfo) {
			UnitType uType = u.second.unitType;
			Position uPos = u.second.unitPos;
			if (!uType.isWorker() && uPos != zeroPos && !uType.isFlyer() 
				&& (uType.groundWeapon() != WeaponTypes::None || uType == Terran_Bunker))
			{
				double distToMe = uType.isFlyer() ? sqrt(DistSq2(uPos, myMainCenter)) 
					: BWEB::Map::getGroundDistance(uPos, myMainCenter);
				
				if (distToMe < bestDist)
				{
					hisLeaderPos = uPos;
					bestDist = distToMe;
				}
			}
		}

		if (hisLeaderPos && hisLeaderPos != Positions::None && hisLeaderPos != zeroPos) {
			//X->drawCircleMap(hisLeaderPos, 8, Colors::White, true);
			int battleRadius = 484; //CountHisUnits(Terran_Siege_Tank_Siege_Mode) ? 480 : 320;
			int battleRadius2 = battleRadius * battleRadius;
			int hisScore = 0;
			int myScore = 0;
			int myScore2 = 0;

			for (auto u : hisUnitIDAndInfo) {
				UnitType uType = u.second.unitType;
				Position uPos = u.second.unitPos;
				if (!uType.isWorker() && uPos != zeroPos && !uType.isFlyer() 
					&& (uType.groundWeapon() != WeaponTypes::None || uType == Terran_Bunker))
				{
					int distToHisLeader = static_cast<int>(uType.isFlyer() ? sqrt(DistSq2(uPos, hisLeaderPos)) 
						: BWEB::Map::getGroundDistance(uPos, hisLeaderPos));

					if (distToHisLeader <= battleRadius) hisScore += EffectivePrice(uType);
				}
			}

			for (Unit u : C->getUnits()) {
				if (L(u) && u->isCompleted() && !Q.isFlyer() && Q.groundWeapon() != WeaponTypes::None) {
					int distToHisLeader2 = DistSq2(u->getPosition(), hisLeaderPos);
					if (distToHisLeader2 <= battleRadius2) myScore += EffectivePrice(Q);
					if (distToHisLeader2 <= 2 * battleRadius2) myScore2 += EffectivePrice(Q);
				}
			}

			if (myScore >= hisScore || 2 * myScore2 >= 3 * hisScore) myAttackStartedSince = currentFrame;
		}
	} 
	else if (opMode > 99) {
		Unit myLeader = NULL;
		int bestDist = 99999;

		// Get my army leader
		if (hisMainCenter != Positions::None)
			for (Unit u : C->getUnits()) {
				if (Q == Protoss_Zealot || Q == Protoss_Dragoon || Q == Protoss_Dark_Templar)
				{
					int distTohisMain = static_cast<int>(BWEB::Map::getGroundDistance(u->getPosition(), hisMainCenter));
					if (distTohisMain < bestDist)
					{
						myLeader = u;
						bestDist = distTohisMain;
					}
				}
			}

		if (myLeader != NULL) {
			Position myLeaderPos = myLeader->getPosition();
			Unitset foesNearby = GR(myLeaderPos, 320, BE && !BW && FCA);
			Unitset friendsNearby = GR(myLeaderPos, 320, BO && !BW && FCA);
			vector<UnitType> hisTypes = {};
			if (enemyRace.compare("_P") == 0) hisTypes = { Protoss_Zealot, Protoss_Dragoon, Protoss_Dark_Templar, Protoss_Archon,
				Protoss_Reaver, Protoss_Scout, Protoss_Carrier, Protoss_Photon_Cannon };
			else if (enemyRace.compare("_T") == 0) hisTypes = { Terran_Marine, Terran_Firebat, Terran_Medic, Terran_Ghost,
				Terran_Vulture, Terran_Siege_Tank_Tank_Mode, Terran_Siege_Tank_Siege_Mode, Terran_Goliath, Terran_Wraith, Terran_Battlecruiser, Terran_Bunker };
			else if (enemyRace.compare("_Z") == 0) hisTypes = { Zerg_Zergling, Zerg_Hydralisk, Zerg_Lurker, Zerg_Mutalisk, Zerg_Ultralisk, Zerg_Sunken_Colony };

			double hisScore = 0;
			double hisScore2 = 0;
			double myScore = 0;

			for (auto u : hisTypes)
				hisScore += CountHisUnits(u) * EffectivePrice(u);

			for (auto u : foesNearby)
				hisScore2 += EffectivePrice(Q) * (u->getHitPoints() + u->getShields()) / double(Q.maxHitPoints() + Q.maxShields());

			for (auto u : friendsNearby)
				myScore += EffectivePrice(Q) * (u->getHitPoints() + u->getShields()) / double(Q.maxHitPoints() + Q.maxShields());

			if (myScore > hisScore
				|| myScore > 1.7 * hisScore2
				|| DistSq2(myLeaderPos, myMainCenter) < 49 * 1024
				|| any_of(C->getUnits().begin(), C->getUnits().end(), [](Unit u1) {
				return u1->isCompleted() && u1->isUnderAttack() && u1->getType().isBuilding(); })
				|| !GR(myMainCenter, 7 * 32, BE && !BW && FCA && !B(Flying)).empty()
				) 
				myAttackStartedSince = currentFrame; /// maybe?
				//return true;
		}
	}
} // void UpdateAttackInfo()

bool MeMoveOut() { // time to signal moving out for the first time
	if (!CC(Protoss_Zealot) && !CC(Protoss_Dragoon) && !CC(Protoss_Dark_Templar) 
		&& !CC(Protoss_Reaver) && !CC(Protoss_Carrier) && !CC(Protoss_Scout) && !CC(Protoss_Corsair))
		return false;

	if (hisMain == TilePositions::None) return false;

	if (myBO == 1) return myUnitsCreated[Protoss_Zealot] >= 4;

	if (myBO == 2 || myBO == 4) return myUnitsCreated[Protoss_Dark_Templar];

	if (myBO == 3) {
		if (enemyRace.compare("_Z") == 0) {
			if (myUnitsCreated[Protoss_Scout] >= 2
				|| myUnitsCreated[Protoss_Corsair]
				)
				return true;
		}
		else {
			if (myUnitsCreated[Protoss_Reaver])
				return true;
		}
		return false;
	}

	if (myBO == 5) {
		if (myUnitsCreated[Protoss_Reaver] && myUnitsCreated[Protoss_Shuttle]) return true;
	}

	if (myBO == 6) {
		if (myUnitsCreated[Protoss_Dragoon] >= 2) return true;
	}

	return false;
} // bool MeSmash()

void GroundUnitsSearchBases(Unit u) {
	auto it = distsAndBases.begin();
	std::advance(it, rand() % distsAndBases.size());
	double random_key = it->first;
	SmartMove(u, Position(distsAndBases[random_key]));
}

void AnalyzeHisBO() {
	if (enemyRace.compare("_P") == 0) {
		/// Zealot rush
		if (currentFrame < 6480 // 4:30
			&& hisUnitsCreated[Protoss_Zealot] >= 6
			|| currentFrame < 7200 // 5:00
			&& hisUnitsCreated[Protoss_Zealot] >= 10)
		{
			hisBO = 11;
			return;
		}

		/// Cannon rush
		if (currentFrame < 4320) // near main, 3:00
			if (Unit hisProxyBldg = X GC(myMainCenter, BE && (FGT == Protoss_Pylon || FGT == Protoss_Photon_Cannon), 24 * 32))
			{
				hisBO = 12;
				return;
			}

		if (hisBO != 12 && currentFrame < 7200) // near nat
			if (Unit hisProxyBldg = X GC(myNatCenter, BE && (FGT == Protoss_Pylon || FGT == Protoss_Photon_Cannon), 15 * 32))
			{
				hisBO = 13;
				return;
			}
	}
	else if (enemyRace.compare("_T") == 0) {
		/// Marine rush
		if (currentFrame < 6240 // 4:20
			&& hisUnitsCreated[Terran_Marine] >= 4
			|| currentFrame < 6960 // 4:50
			&& hisUnitsCreated[Terran_Marine] >= 6
			)
		{
			hisBO = 21;
			return;
		}

		/// Worker rush
		if (currentFrame < 5040 // 3:30
			&& count_if(hisUnitIDAndInfo.begin(), hisUnitIDAndInfo.end(), [](const auto & u) { 
			return u.second.unitType == Terran_SCV && DistSq2(u.second.unitPos, myMainCenter) <= 900 * 1024; }) >= 3)
		{
			hisBO = 22;
			return;
		}

		if (hisBO == 21) {
			if (hisUnitsCreated[Terran_Vulture]
				+ hisUnitsCreated[Terran_Siege_Tank_Tank_Mode]
				+ hisUnitsCreated[Terran_Goliath]
				+ hisUnitsCreated[Terran_Wraith] >= 6)
			{
				hisBO = 0;
				return;
			}
		}
	}
	else if (enemyRace.compare("_Z") == 0) {
		/// 4-pool
		if (currentFrame < 4560) // 3:10
			if (Unit hisLing = X GC(myMainCenter, BE && FGT == Zerg_Zergling, 24 * 32))
			{
				hisBO = 31;
				return;
			}

		/// Ling flood
		if (hisBO != 31) {
			if (currentFrame < 6000 // 4:10
				&& CountHisUnits(Zerg_Zergling) + hisDeadUnits[Zerg_Zergling] >= 10
				|| currentFrame < 7200 // 5:00
				&& CountHisUnits(Zerg_Zergling) + hisDeadUnits[Zerg_Zergling] >= 14)
			{
				hisBO = 32;
				return;
			}
		}

		if (hisBO == 31) {
			if (hisUnitsCreated[Zerg_Hydralisk] >= 3)
			{
				hisBO = 0;
				return;
			}
		}

		if (hisBO == 32) {
			if (hisUnitsCreated[Zerg_Hydralisk]
				+ hisUnitsCreated[Zerg_Mutalisk]
				+ hisUnitsCreated[Zerg_Ultralisk] >= 3)
			{
				hisBO = 0;
				return;
			}
		}
	}
}

int GetStartingInd(TilePosition startingLoc) {
	switch (thisMapIndex) {
	case 0: if (startingLoc == TilePosition(117, 13)) return thisMapIndex * 10 + 1;
			else return thisMapIndex * 10 + 2;
		break; // Benzene
	case 1: if (startingLoc == TilePosition(64, 118)) return thisMapIndex * 10 + 1;
			else return thisMapIndex * 10 + 2;
		break; // Destination
	case 2: if (startingLoc == TilePosition(117, 56)) return thisMapIndex * 10 + 1;
			else return thisMapIndex * 10 + 2;
		break; // HBR
	case 4: if (startingLoc == TilePosition(117, 100)) return thisMapIndex * 10 + 1;
			else if (startingLoc == TilePosition(7, 82)) return thisMapIndex * 10 + 2;
			else return thisMapIndex * 10 + 3;
		break; // Aztec == Neo Aztec (torchup)
	case 5: if (startingLoc == TilePosition(117, 96)) return thisMapIndex * 10 + 1;
			else if (startingLoc == TilePosition(7, 90)) return thisMapIndex * 10 + 2;
			else return thisMapIndex * 10 + 3;
		break; // NMG
	case 6: if (startingLoc == TilePosition(117, 9)) return thisMapIndex * 10 + 1;
			else if (startingLoc == TilePosition(93, 118)) return thisMapIndex * 10 + 2;
			else return thisMapIndex * 10 + 3;
		break; // TC
	case 7: if (startingLoc == TilePosition(117, 7)) return thisMapIndex * 10 + 1;
			else if (startingLoc == TilePosition(117, 119)) return thisMapIndex * 10 + 2;
			else if (startingLoc == TilePosition(7, 118)) return thisMapIndex * 10 + 3;
			else return thisMapIndex * 10 + 4;
		break; // Andromeda
	case 8: if (startingLoc == TilePosition(117, 9)) return thisMapIndex * 10 + 1;
			else if (startingLoc == TilePosition(117, 118)) return thisMapIndex * 10 + 2;
			else if (startingLoc == TilePosition(7, 118)) return thisMapIndex * 10 + 3;
			else return thisMapIndex * 10 + 4;
		break; // Circuit Breaker
	case 9: if (startingLoc == TilePosition(117, 13)) return thisMapIndex * 10 + 1;
			else if (startingLoc == TilePosition(117, 111)) return thisMapIndex * 10 + 2;
			else if (startingLoc == TilePosition(7, 112)) return thisMapIndex * 10 + 3;
			else return thisMapIndex * 10 + 4;
		break; // Eddy
	case 10: if (startingLoc == TilePosition(117, 6)) return thisMapIndex * 10 + 1;
			 else if (startingLoc == TilePosition(117, 119)) return thisMapIndex * 10 + 2;
			 else if (startingLoc == TilePosition(7, 119)) return thisMapIndex * 10 + 3;
			 else return thisMapIndex * 10 + 4;
		break; // Empire of the Sun
	case 11: if (startingLoc == TilePosition(117, 7)) return thisMapIndex * 10 + 1;
			 else if (startingLoc == TilePosition(117, 117)) return thisMapIndex * 10 + 2;
			 else if (startingLoc == TilePosition(7, 116)) return thisMapIndex * 10 + 3;
			 else return thisMapIndex * 10 + 4;
		break; // Fighting Spirit
	case 12: if (startingLoc == TilePosition(116, 47)) return thisMapIndex * 10 + 1;
			 else if (startingLoc == TilePosition(81, 118)) return thisMapIndex * 10 + 2;
			 else if (startingLoc == TilePosition(8, 77)) return thisMapIndex * 10 + 3;
			 else return thisMapIndex * 10 + 4;
		break; // Icarus
	case 13: if (startingLoc == TilePosition(117, 7)) return thisMapIndex * 10 + 1;
			 else if (startingLoc == TilePosition(117, 117)) return thisMapIndex * 10 + 2;
			 else if (startingLoc == TilePosition(8, 117)) return thisMapIndex * 10 + 3;
			 else return thisMapIndex * 10 + 4;
		break; // Jade
	case 14: if (startingLoc == TilePosition(116, 6)) return thisMapIndex * 10 + 1;
			 else if (startingLoc == TilePosition(116, 117)) return thisMapIndex * 10 + 2;
			 else if (startingLoc == TilePosition(8, 117)) return thisMapIndex * 10 + 3;
			 else return thisMapIndex * 10 + 4;
		break; // La Mancha
	case 15: if (startingLoc == TilePosition(83, 6)) return thisMapIndex * 10 + 1;
			 else if (startingLoc == TilePosition(117, 40)) return thisMapIndex * 10 + 2;
			 else if (startingLoc == TilePosition(42, 119)) return thisMapIndex * 10 + 3;
			 else return thisMapIndex * 10 + 4;
		break; // Python
	case 16: if (startingLoc == TilePosition(117, 68)) return thisMapIndex * 10 + 1;
			 else if (startingLoc == TilePosition(57, 118)) return thisMapIndex * 10 + 2;
			 else if (startingLoc == TilePosition(7, 57)) return thisMapIndex * 10 + 3;
			 else if (startingLoc == TilePosition(67, 8)) return thisMapIndex * 10 + 4;
		break; // Roadkill
	case 17: if (startingLoc == TilePosition(117, 35)) return thisMapIndex * 10 + 1;
			 else if (startingLoc == TilePosition(98, 119)) return thisMapIndex * 10 + 2;
			 else if (startingLoc == TilePosition(7, 90)) return thisMapIndex * 10 + 3;
			 else return thisMapIndex * 10 + 4;
		break; // Roadrunner
	case 18: if (startingLoc == TilePosition(116, 8)) return thisMapIndex * 10 + 1;
			 else return thisMapIndex * 10 + 2;
		break; // Blue Storm
	case 19: if (startingLoc == TilePosition(117, 110)) return thisMapIndex * 10 + 1;
			 else if (startingLoc == TilePosition(7, 70)) return thisMapIndex * 10 + 2;
			 else return thisMapIndex * 10 + 3;
		break; // Gold Rush
	case 20: if (startingLoc == TilePosition(117, 29)) return thisMapIndex * 10 + 1;
			 else if (startingLoc == TilePosition(69, 118)) return thisMapIndex * 10 + 2;
			 else return thisMapIndex * 10 + 3;
		break; // Power Bond
	case 21: if (startingLoc == TilePosition(117, 20)) return thisMapIndex * 10 + 1;
			 else if (startingLoc == TilePosition(110, 118)) return thisMapIndex * 10 + 2;
			 else if (startingLoc == TilePosition(7, 106)) return thisMapIndex * 10 + 3;
			 else if (startingLoc == TilePosition(14, 7)) return thisMapIndex * 10 + 4;
		break; // Gladiator
	case 22: if (startingLoc == TilePosition(117, 89)) return thisMapIndex * 10 + 1;
			 else if (startingLoc == TilePosition(34, 118)) return thisMapIndex * 10 + 2;
			 else if (startingLoc == TilePosition(7, 34)) return thisMapIndex * 10 + 3;
			 else if (startingLoc == TilePosition(90, 6)) return thisMapIndex * 10 + 4;
		break; // Sparkle
	default:;
	}
	return 0;
} // int GetStartingInd(...)

Position VecToPos(vector<int> vecIn) {
	return Position(TilePosition(vecIn.back(), vecIn.front()));
}

vector<int> PosToVec(TilePosition posIn) {
	vector<int> res;
	res.push_back(posIn.y);
	res.push_back(posIn.x);
	return res;
}

TilePosition GetNearestGoodTile(TilePosition posIn, int gridIn[][128]) {
	// Return if this is already a good tile
	int posInX = posIn.x;
	int posInY = posIn.y;
	if (gridIn[posInX][posInY] == 0) return posIn;

	// Spiral search around `posIn`
	for (int r = 1; r <= 128; ++r) {
		map<int, TilePosition> scoreAndPos;
		for (int i = posInX - r; i <= posInX + r; ++i)
			for (int j = posInY - r; j <= posInY + r; ++j)
				if (i > 0 && i < X->mapWidth() && j > 0 && j < X->mapHeight() && gridIn[i][j] == 0) // Within the map and is good
					if (i == posInX - r || i == posInX + r || j == posInY - r || j == posInY + r) // Only points from the surrounding square frame
						scoreAndPos[DistSq2(Position(i, j), Position(posInX, posInY))] = TilePosition(i, j);

		if (!scoreAndPos.empty())
			return scoreAndPos.begin()->second;
	}
	
	return myMain;
}

double GetMyBOScore(int boI, int opMode = 0) {
	int numAllActions = 0;
	int boITried = 0;
	int boIWon = 0;

	for (int i = 1; i <= myTotalBOs; ++i)
	{
		int boITried0 = myBOStatsActual[i * 2 - 2];
		numAllActions += boITried0;

		if (i == boI) {
			boITried = boITried0;
			boIWon = myBOStatsActual[i * 2 - 1];
		}
	}

	if (numAllActions == 0 || boITried == 0) return 0.5;

	if (opMode == 1) return boIWon / double(boITried) + sqrt(2 * log(numAllActions) / double(boITried)); // UCB1
	else return boIWon / double(boITried); // Default: frequentist
}

struct PylonPuller :AIModule {
	void onStart() {
		myMain = C->getStartLocation();
		myMainCenter = Position(myMain) + Position(64, 48);
		X->setCommandOptimizationLevel(1);
		X->enableFlag(Flag::UserInput);

		const vector<string> mapHashes = {
					"af618ea3ed8a8926ca7b17619eebcb9126f0d8b1", // Benzene ==> 0
					"4e24f217d2fe4dbfa6799bc57f74d8dc939d425b", // Destination
					"6f8da3c3cc8d08d9cf882700efa049280aedca8c", // Heartbreak Ridge
					"a697fc93c38b098d94ae0ccddaf2eb7aac137b8a", // New Heartbreak Ridge
					"e6d0144e14315118d916905ff5e7045f68db541e", // Aztec == Neo Aztec (torchup)
					"c8386b87051f6773f6b2681b0e8318244aa086a6", // Neo Moon Glaive ==> 5
					"9bfc271360fa5bab3707a29e1326b84d0ff58911", // Tau Cross
					"1e983eb6bcfa02ef7d75bd572cb59ad3aab49285", // Andromeda
					"450a792de0e544b51af5de578061cb8a2f020f32", // Circuit Breaker
					"3078ee93e4a0c3c2ad22c73ab62ef806d9436c3d", // Eddy
					"a220d93efdf05a439b83546a579953c63c863ca7", // Empire of the Sun ==> 10
					"d2f5633cc4bb0fca13cd1250729d5530c82c7451", // Fighting Spirit
					"0409ca0d7fe0c7f4083a70996a8f28f664d2fe37", // Icarus
					"df21ac8f19f805e1e0d4e9aa9484969528195d9f", // Jade
					"e47775e171fe3f67cc2946825f00a6993b5a415e", // La Mancha
					"de2ada75fbc741cfa261ee467bf6416b10f9e301", // Python ==> 15
					"b997dbc7792e7067668ff56a33793a43b35ffdd2", // Roadkill 1.08
					"9a4498a896b28d115129624f1c05322f48188fe0", // Roadrunner
					"aab66dbf9c85f85c47c219277e1e36181fe5f9fc", // Blue Storm
					"666dd28cd3c85223ebc749a481fc281e58221e4a", // Gold Rush
					"731138b5b844a4a0b4a4bb4e495969fd6659414c", // Power Bond ==> 20
					"798bea3acce68788ff1b32d9d777ba7a12c883a1", // Gladiator
					"099930076c0a873b8dc82e8b9646590fd4c887a3"	// Sparkle
		};

		auto thisMapIt = std::find(mapHashes.begin(), mapHashes.end(), X->mapHash());
		if (thisMapIt != mapHashes.end()) // map found!
			thisMapIndex = static_cast<int>(std::distance(mapHashes.begin(), thisMapIt));

		myStartingInd = GetStartingInd(myMain);

		enemyName = XE->getName();
		if (XE->getRace() == Races::Protoss) enemyRace = "_P";
		else if (XE->getRace() == Races::Terran) enemyRace = "_T";
		else if (XE->getRace() == Races::Zerg) enemyRace = "_Z";
		
		// Only do this when enemy race is known!
		if (enemyRace.compare("Unknown") != 0) {
			// Read my recent stats..
			ifstream mf3("bwapi-data/read/" + enemyName + enemyRace + "_RECENT.txt");
			if (mf3) {
				int myRecentStatsTemp[numMyRecentStats] = { 0 };
				int td = -1; int lc;
				while (mf3 >> lc) { ++td; myRecentStatsTemp[td] = lc; }

				for (int i = 0; i < numMyRecentStats; ++i)
					myRecentStats[numMyRecentStats - td - 1 + i] = myRecentStatsTemp[i];

				mf3.close();
			}

			// Read my BO stats
			ifstream mf("bwapi-data/read/" + enemyName + enemyRace + ".txt");
			if (mf) {
				int td = -1; int lc; while (mf >> lc) { ++td; myBOStats[td] = lc; } mf.close();

				// Process my actual BO stats
				if (myRecentStats[0] > 0) {
					for (int i = 0; i < numMyRecentStats; ++i)
					{
						int iMyBO = (myRecentStats[i] % 100) / 10;
						if (std::count(myFeasibleBOs.begin(), myFeasibleBOs.end(), iMyBO))
						{
							myBOStatsActual[iMyBO * 2 - 2]++;
							if (myRecentStats[i] % 10) myBOStatsActual[iMyBO * 2 - 1]++;
						}
					}
				}
				else std::copy(std::begin(myBOStats), std::end(myBOStats), std::begin(myBOStatsActual));

				double bestReward = -0.1;

				for (int iBO : myFeasibleBOs)
				{
					double iReward = GetMyBOScore(iBO);
					if (iReward > bestReward) {
						myBO = iBO;
						bestReward = iReward;
					}
				}

				if (rand() % 100 >= 90 // alpha-greedy, exploration
					|| bestReward <= 0.1 // if the current BO performs poorly
					) {
					// Find the `myBO` that is explored the least
					int minTried = INT_MAX;
					for (auto u : myFeasibleBOs) {
						int uTried = myBOStatsActual[u * 2 - 2];
						if (uTried < minTried) {
							minTried = uTried;
							myBO = u;
						}
					}
				}
			}
			else myBO = rand() % myTotalBOs + 1; // no record -> random BO
		} // Read info
		else myBO = rand() % myTotalBOs + 1; // random BO when his race is truly random

		int hisPrevBO = 0;
		int myPrevStats = myRecentStats[numMyRecentStats - 1];
		if (myPrevStats > 100)
			hisPrevBO = (myPrevStats - myPrevStats % 100) / 100;

		int myBO0 = 0;
		if (hisPrevBO == 11 || hisPrevBO == 21 || hisPrevBO == 32) myBO0 = 2;
		else if (hisPrevBO == 13 || hisPrevBO == 22 || hisPrevBO == 31) myBO0 = 3;
		else if (hisPrevBO == 12) myBO0 = GetMyBOScore(1) > GetMyBOScore(3) ? 1 : 3;
		
		if (std::count(myFeasibleBOs.begin(), myFeasibleBOs.end(), myBO0))
			if (myBOStatsActual[myBO0 * 2 - 2] < 2 
				//|| myBOStatsActual[myBO0 * 2 - 2] <= 2 * myBOStatsActual[myBO0 * 2 - 1]
				|| GetMyBOScore(myBO0) >= GetMyBOScore(myBO)
				)
				myBO = myBO0;

		if (myBO > myTotalBOs) myBO = rand() % myTotalBOs + 1;

		/// vvv fix things here vvv
		//myBO = 2;

		/// switch(myBO) {...}
		//case 1: 4-gate zealot;
		//case 2: cannon-dt;
		//case 3: cannon-reaver(PT)-air(Z)
		//case 4: almost naked dt rush
		//case 5: almost naked reaver drop
		//case 6: goon-dt-scout

		/// BO-specific parameters
		if (myBO == 2) myMaxCannons = 5;
		else if (myBO == 3) myMaxCannons = enemyRace.compare("_Z") == 0 ? 3 : 2;
		else if (myBO == 4) myMaxCannons = 0;

		//////////////////////////////////////////////////
		numStartingLocs = X->getStartLocations().size();
		bwemMapInstance.Initialize();
		bwemMapInstance.FindBasesForStartingLocations();
		GetMyNaturalAndOtherBases(bwemMapInstance);
		BWEB::Map::onStart();
		myCP = Position(BWEB::Map::getMainChoke()->Center());
		myNatCP = Position(BWEB::Map::getNaturalChoke()->Center());

		for (TilePosition u : X->getStartLocations()) u != myMain ? hisPossibleDs.push_back(u) : "a"; 
		
		p(my3rd); p(myNat); p(myMain); // add mineral patches around locations

		for (TilePosition sl : X->getStartLocations())
			if (sl != myMain)
				myScoutTargetsAndStatus[sl] = false;

		hisInfo.reserve(3600 / secondsPerTick + 1); // Assuming BASIL env, where games last for 60 minutes maximum

		if (enemyRace.compare("_P") == 0) hisTypesToCheck = {
			Protoss_Probe, Protoss_Zealot, Protoss_Dragoon,
			Protoss_High_Templar, Protoss_Dark_Templar, Protoss_Archon,
			Protoss_Dark_Archon, Protoss_Reaver, Protoss_Observer,
			Protoss_Shuttle, Protoss_Scout, Protoss_Carrier,
			Protoss_Arbiter, Protoss_Corsair, Protoss_Photon_Cannon };
		else if (enemyRace.compare("_T") == 0) hisTypesToCheck = {
			Terran_SCV, Terran_Marine, Terran_Firebat,
			Terran_Medic, Terran_Ghost, Terran_Vulture,
			Terran_Siege_Tank_Tank_Mode, Terran_Goliath,
			Terran_Wraith, Terran_Valkyrie, Terran_Battlecruiser,
			Terran_Science_Vessel, Terran_Dropship, Terran_Bunker };
		else if (enemyRace.compare("_Z") == 0) hisTypesToCheck = {
			Zerg_Drone, Zerg_Zergling, Zerg_Hydralisk,
			Zerg_Lurker, Zerg_Ultralisk, Zerg_Defiler,
			Zerg_Overlord, Zerg_Mutalisk, Zerg_Scourge,
			Zerg_Queen, Zerg_Guardian, Zerg_Devourer
		};

		// Dispatch the initial four workers to the closest mineral patches
		Unitset myStartingMPs = GR(myMainCenter, 320, B(Neutral) && BM);
		vector<Unit> myClosestMPs;
		map<int, Unit> distAndMP;
		for (auto u : myStartingMPs)
			distAndMP[DistSq2(u->getPosition(), myMainCenter)] = u;

		for (auto it = distAndMP.begin(); it != distAndMP.end(); it++)
			myClosestMPs.push_back(it->second);

		for (auto u : C->getUnits())
			if (u->isCompleted() && Q == Protoss_Probe && !myClosestMPs.empty())
			{
				q[u] = myClosestMPs.front();
				myClosestMPs.erase(myClosestMPs.begin());
			}
	} // onStart()

	void onFrame() {
		// Initializing...
		currentFrame = X->getFrameCount();
		bool myNatBuilt = !GR(myNatCenter, 160, BO && BR).empty();
		bool my3rdBuilt = !GR(my3rdCenter, 160, BO && BR).empty();



		if (hisMain != TilePositions::None) {
			if (hisStartingInd == 0) hisStartingInd = GetStartingInd(hisMain);

			if (hisMainCenter == Positions::None) hisMainCenter = Position(hisMain) + Position(64, 48);
			if (hisNatCenter == Positions::None) hisNatCenter = Position(FindNatPos(bwemMapInstance, hisMain)) + Position(64, 48);

			// Updating enemy starting base status...
			if (!hisMainKilled)
				if (!GR(hisMainCenter, 160, BO).empty() && GR(hisMainCenter, 160, BE && BR).empty())
					hisMainKilled = true;
		}

		// update hisInfo every X seconds, assuming max game time is 60 minutes
		if (currentFrame <= 86401) {			
			if ((currentFrame - 1) % 24 == 0
				&& currentFrame > 1200
				) {
				AnalyzeHisBO();
				UpdateAttackInfo(myBO);
			}

			if ((currentFrame - 1) % framesPerTick == 0) {
				if (enemyRace.compare("Unknown") == 0 && currentFrame)
				{
					if (XE->getRace() == Races::Protoss) enemyRace = "_P";
					else if (XE->getRace() == Races::Terran) enemyRace = "_T";
					else if (XE->getRace() == Races::Zerg) enemyRace = "_Z";
				}

				string thisStr;
				for (auto i : hisTypesToCheck)
					thisStr.push_back(Num2Char(CountHisUnits(i)));

				hisInfo.push_back(thisStr);
			}

			if ((currentFrame - 1) % 4 == 0) {
				for (auto u : XE->getUnits()) {
					if (Q.isBuilding()) {
						if (u->exists()) hisUnitIDAndInfo[u->getID()].lastFrameVisible = currentFrame;
					}
					else { // non-building
						if (u->exists()) {
							hisUnitIDAndInfo[u->getID()].unitPos = u->getPosition();
							hisUnitIDAndInfo[u->getID()].unitSpd = std::make_pair(u->getVelocityX(), u->getVelocityY());
							hisUnitIDAndInfo[u->getID()].lastFrameVisible = currentFrame;
						}
						else if (!u->isVisible() && currentFrame - hisUnitIDAndInfo[u->getID()].lastFrameVisible > 120) { // reset the speed data
							hisUnitIDAndInfo[u->getID()].unitSpd.first = hisUnitIDAndInfo[u->getID()].unitSpd.second = 0.0;
						}
					}
				}
			}
		}

		bool hasNat = !GR(myNatCenter, 96, BO && BR).empty();
		bool has3rd = !GR(my3rdCenter, 96, BO && BR).empty();
		
		
		int gridInfo[128][128] = { 0 };
		map<int, int> shuttleReaverPair = {};
		if (myBO == 5 && myUnitsCreated[Protoss_Dragoon] < 8) {
			if (CC(Protoss_Shuttle) && CC(Protoss_Reaver)) {
				int numPairs = min(CC(Protoss_Shuttle), CC(Protoss_Reaver));
				vector<int> shuttleIDs;
				vector<int> reaverIDs;

				for (Unit u : C->getUnits())
					if (L(u) && u->isCompleted())
					{
						if (Q == Protoss_Shuttle) shuttleIDs.push_back(u->getID()); 
						else if (Q == Protoss_Reaver) reaverIDs.push_back(u->getID());
					}

				sort(shuttleIDs.begin(), shuttleIDs.end());
				sort(reaverIDs.begin(), reaverIDs.end());

				for (int i = 0; i < numPairs; ++i)
					shuttleReaverPair[shuttleIDs[i]] = reaverIDs[i];
			}

			for (int k = 1; k < 8; ++k) {
				UnitType kType = GetThreatType(k);
				bool considerSpeed = k >= 3;

				if (kType != UnitTypes::None) {
					for (int i = 0; i < 128; ++i) { // X direction
						for (int j = 0; j < 128; ++j) { // Y direction
							if (gridInfo[i][j] == 0) {
								Position posIJ((i + 1) * 32 - 16, (j + 1) * 32 - 16);
								if (considerSpeed) // forecast positions after 2 seconds
									if (any_of(hisUnitIDAndInfo.begin(), hisUnitIDAndInfo.end(), [&posIJ, &kType](const auto & u)
									{ return u.second.unitType == kType
										&& DistSq2(Position(u.second.unitPos.x + int(u.second.unitSpd.first * 48),
											u.second.unitPos.y + int(u.second.unitSpd.second * 48)), posIJ) <= 64 * 1024; }))
										gridInfo[i][j] = 1;

								if (any_of(hisUnitIDAndInfo.begin(), hisUnitIDAndInfo.end(), [&posIJ, &kType](const auto & u)
								{ return u.second.unitType == kType && DistSq2(u.second.unitPos, posIJ) <= 64 * 1024; })) 
									gridInfo[i][j] = 1;

								/// Visualization
								//X->drawBoxMap(posIJ - Position(16, 16), posIJ + Position(16, 16), gridInfo[i][j] ? Colors::Red : Colors::Green, false);
								//X->drawLineMap(posIJ - Position(16, 16), posIJ + Position(16, 16), gridInfo[i][j] ? Colors::Red : Colors::Green);
							}
						} // Y direction
					} // X direction
				} // consider `kType`?
			}
		} // update `gridInfo`

		// Construct my buildings...
		int firstPylonSupply = 16;
		if (myBO == 3) firstPylonSupply = 14;

		TilePosition myHalfCP = (myMain + TilePosition(myCP)) / 2;
		if (myStartingInd == 71) myHalfCP = TilePosition(121, 16);
		else if (myStartingInd == 72) myHalfCP = TilePosition(121, 112);
		else if (myStartingInd == 73) myHalfCP = TilePosition(6, 111);
		else if (myStartingInd == 74) myHalfCP = TilePosition(6, 16);

		if (C->supplyUsed() >= firstPylonSupply && CL(Protoss_Pylon) == 0 && C->minerals() > 80) Warp(Protoss_Pylon, myHalfCP);
		
		int maxSupplyGap = 4;
		if (CC(Protoss_Stargate)) maxSupplyGap = 6;
		if (CC(Protoss_Robotics_Support_Bay)) maxSupplyGap = 8;

		if (C->supplyTotal() - C->supplyUsed() <= maxSupplyGap && C->supplyTotal() < 400
			&& CC(Protoss_Pylon) && CW(Protoss_Pylon) == 0 && C->minerals() > 80) {
			if (myBO == 2 && CL(Protoss_Pylon) < 2) Warp(Protoss_Pylon, myHalfCP);
			else Warp(Protoss_Pylon);
		}
		if (myBO == 2 && CC(Protoss_Pylon) == 2 && CL(Protoss_Pylon) < 3 && C->minerals() > 600 ) Warp(Protoss_Pylon);

		if (hisBO == 22) // more pylons vs worker rush
			if (CC(Protoss_Photon_Cannon) + CC(Protoss_Gateway) 
				&& (CL(Protoss_Pylon) < 2 && C->minerals() > 120 || CL(Protoss_Pylon) < 3 && C->minerals() > 220)
				|| CL(Protoss_Forge) && CL(Protoss_Pylon) < 3 && C->minerals() > 250)
				Warp(Protoss_Pylon);

		bool ignoreObs = true;
		if (myBO != 1) {
			if (CountHisUnits(Protoss_Dark_Templar) 
				//|| CountHisUnits(Terran_Wraith) iffy
				|| CountHisUnits(Zerg_Lurker))
				if (myUnitsCreated[Protoss_Observer] == 0 && CW(Protoss_Observer) == 0)
					ignoreObs = false;

			if (myBOStats[myBOStatsSize - 1] > 3000) { // last entry of `myBOStats`
				int frameDiffMax = 2100;
				if (myBO == 1) frameDiffMax = 3000;
				else if (myBO == 3 && enemyRace.compare("_Z") || myBO == 5) frameDiffMax = 1000;

				if (myBOStats[myBOStatsSize - 1] - currentFrame < frameDiffMax)
					ignoreObs = false;
			}
		}

		if (CC(Protoss_Pylon)) {
			int idleGateways = 0;
			if (CC(Protoss_Gateway))
				idleGateways = CC(Protoss_Gateway) - CW(Protoss_Zealot) - CW(Protoss_Dragoon) - CW(Protoss_Dark_Templar);

			if (!ignoreObs) { // Get observer pls
				if (C->minerals() > 60 && CL(Protoss_Assimilator) == 0) Warp(Protoss_Assimilator);
				if (CL(Protoss_Assimilator) && C->minerals() > 150 && CL(Protoss_Cybernetics_Core) == 0) Warp(Protoss_Cybernetics_Core);
				if (CC(Protoss_Cybernetics_Core) && C->minerals() > 100 && CL(Protoss_Robotics_Facility) == 0) Warp(Protoss_Robotics_Facility);
				if (CC(Protoss_Robotics_Facility) && CL(Protoss_Observatory) == 0) Warp(Protoss_Observatory);
			}

			if (myBO == 1) {
				if (hisBO != 31 || CC(Protoss_Gateway) == 0 || myUnitsCreated[Protoss_Zealot] >= 12) { // Emergency break vs 4-pool
					if (C->supplyUsed() >= 18 && C->minerals() > 120 && CL(Protoss_Gateway) < 2) Warp(Protoss_Gateway);
					if (C->minerals() > 120 && CL(Protoss_Gateway) < 2) Warp(Protoss_Gateway);

					if (CC(Protoss_Gateway) >= 2 && CL(Protoss_Gateway) < 4)
						if (idleGateways == 0 || C->minerals() > 150 + 150 * idleGateways)
							Warp(Protoss_Gateway);

					if (CC(Protoss_Gateway) >= 4 && CL(Protoss_Nexus) < 2 && C->minerals() > 400) Warp(Protoss_Nexus, myNat);
				}
			}
			else if (myBO == 2 || myBO == 4 || myBO == 6) {
				if (myMaxCannons && C->supplyUsed() >= 18 && C->minerals() > 120 && CL(Protoss_Forge) == 0) Warp(Protoss_Forge);
				if (CC(Protoss_Forge) && C->minerals() > 120 && CL(Protoss_Photon_Cannon) < myMaxCannons) Warp(Protoss_Photon_Cannon, TilePosition(myCP));
				if (CL(Protoss_Photon_Cannon) >= myMaxCannons && C->minerals() > 120 && CL(Protoss_Gateway) == 0) Warp(Protoss_Gateway);
				if (CL(Protoss_Gateway) && C->minerals() > 60 && CL(Protoss_Assimilator) == 0) Warp(Protoss_Assimilator);
				if (CC(Protoss_Gateway) && CL(Protoss_Assimilator) && C->minerals() > 150 && CL(Protoss_Cybernetics_Core) == 0) Warp(Protoss_Cybernetics_Core);
				
				if (myBO == 6) {
					if (myUnitsCreated[Protoss_Dark_Templar] >= 2
						&& CC(Protoss_Cybernetics_Core) && C->minerals() > 100 && CL(Protoss_Stargate) == 0) Warp(Protoss_Stargate);
					if (CL(Protoss_Templar_Archives) && C->minerals() > 100 && CL(Protoss_Gateway) < 3) Warp(Protoss_Gateway);
				}

				if (CL(Protoss_Cybernetics_Core) && C->minerals() > 100 && CL(Protoss_Gateway) < 3) Warp(Protoss_Gateway);
				if (CC(Protoss_Cybernetics_Core) && C->minerals() > 100 && CL(Protoss_Citadel_of_Adun) == 0) Warp(Protoss_Citadel_of_Adun);
				if (CC(Protoss_Citadel_of_Adun) && C->minerals() > 150 && CL(Protoss_Templar_Archives) == 0) Warp(Protoss_Templar_Archives);
				
				if (myUnitsCreated[Protoss_Dark_Templar] > 4 && CL(Protoss_Nexus) < 2 && C->minerals() > 400) Warp(Protoss_Nexus, myNat);
			}
			else if (myBO == 3) {
				if (C->supplyUsed() >= 16 && C->minerals() > 120 && CL(Protoss_Forge) == 0) Warp(Protoss_Forge);
				if (CC(Protoss_Forge) && C->minerals() > 120 && CL(Protoss_Photon_Cannon) < myMaxCannons) Warp(Protoss_Photon_Cannon, TilePosition(myCP));
				if (CL(Protoss_Photon_Cannon) >= myMaxCannons && C->minerals() > 120 && CL(Protoss_Gateway) == 0) Warp(Protoss_Gateway);
				if (CL(Protoss_Gateway) && C->minerals() > 60 && CL(Protoss_Assimilator) == 0) Warp(Protoss_Assimilator);
				if (CC(Protoss_Gateway) && CL(Protoss_Assimilator) && C->minerals() > 150 && CL(Protoss_Cybernetics_Core) == 0) Warp(Protoss_Cybernetics_Core);
				
				// Branch?
				if (enemyRace.compare("_Z") == 0) {
					if (CC(Protoss_Cybernetics_Core) && C->minerals() > 120 && CL(Protoss_Stargate) == 0) Warp(Protoss_Stargate);
					if (CL(Protoss_Stargate) && C->minerals() > 120 && CL(Protoss_Gateway) < 2) Warp(Protoss_Gateway);
					if (myUnitsCreated[Protoss_Scout] >= 2 && CL(Protoss_Nexus) < 2 && C->minerals() > 420) Warp(Protoss_Nexus, myNat);
				}
				else {
					if (CL(Protoss_Cybernetics_Core) && C->minerals() > 100 && CL(Protoss_Gateway) < 2) Warp(Protoss_Gateway);
					if (CC(Protoss_Cybernetics_Core) && C->minerals() > 100 && CL(Protoss_Robotics_Facility) == 0) Warp(Protoss_Robotics_Facility);
					if (CC(Protoss_Robotics_Facility) && C->minerals() > 150 && CL(Protoss_Robotics_Support_Bay) == 0) Warp(Protoss_Robotics_Support_Bay);
					if (myUnitsCreated[Protoss_Reaver] >= 3 && CL(Protoss_Nexus) < 2 && C->minerals() > 450) Warp(Protoss_Nexus, myNat);
				}
			}
			else if (myBO == 5) {
				if (C->minerals() > 120 && CL(Protoss_Gateway) == 0) Warp(Protoss_Gateway);
				if (CL(Protoss_Gateway) && C->minerals() > 60 && CL(Protoss_Assimilator) == 0) Warp(Protoss_Assimilator);
				if (CC(Protoss_Gateway) && CL(Protoss_Assimilator) && C->minerals() > 150 && CL(Protoss_Cybernetics_Core) == 0) Warp(Protoss_Cybernetics_Core);
				if (CC(Protoss_Cybernetics_Core) && C->minerals() > 100 && CL(Protoss_Robotics_Facility) == 0) Warp(Protoss_Robotics_Facility);
				if (CL(Protoss_Robotics_Facility) && C->minerals() > 100 && CL(Protoss_Gateway) < 2) Warp(Protoss_Gateway);
				if (CC(Protoss_Robotics_Facility) && C->minerals() > 150 && CL(Protoss_Robotics_Support_Bay) == 0) Warp(Protoss_Robotics_Support_Bay);
				if (myUnitsCreated[Protoss_Reaver] >= 2 && myUnitsCreated[Protoss_Shuttle] >= 2
					&& CL(Protoss_Nexus) < 2 && C->minerals() > 450) Warp(Protoss_Nexus, myNat);

				// when on 2 bases..
				if (CL(Protoss_Nexus) <= 2) {
					if (CC(Protoss_Gateway) >= 2 * CC(Protoss_Nexus)
						&& C->minerals() > 400 + 150 * idleGateways) 
						Warp(Protoss_Nexus, (CL(Protoss_Nexus) == 1 ? myNat : my3rd));
				}

				if (CL(Protoss_Gateway) < min(2 * CL(Protoss_Nexus), 3)
					&& C->minerals() > 150 + 150 * idleGateways) Warp(Protoss_Gateway);
			}

			if (myBO == 3 || myBO == 4 || myBO == 6)
				if (CC(Protoss_Nexus) >= 2 && CC(Protoss_Assimilator) >= 2
					&& CC(Protoss_Probe) >= 28 && C->minerals() > 280 && CL(Protoss_Gateway) < 4) Warp(Protoss_Gateway);

			if (hisMainKilled && CC(Protoss_Gateway)) { // assumes we have a gateway..
				if (C->minerals() > 100 && CL(Protoss_Assimilator) == 0) Warp(Protoss_Assimilator);
				if (CL(Protoss_Assimilator) && C->minerals() > 200 && CL(Protoss_Cybernetics_Core) == 0) Warp(Protoss_Cybernetics_Core);
				if (CC(Protoss_Cybernetics_Core) && C->minerals() > 150 && C->gas() > 150 && CL(Protoss_Stargate) == 0) Warp(Protoss_Stargate);
			}
		} // CC(Protoss_Pylon)
		
		if (CL(Protoss_Assimilator) < 2 && hasNat && C->minerals() >= 100
			&& GR(myNatCenter, 8 * 32, BO && FGT == Protoss_Assimilator).empty()) // Assimilator at nat
			Warp(Protoss_Assimilator, myNat);

		if (CL(Protoss_Assimilator) < 3 && hasNat && has3rd && C->minerals() >= 100
			&& GR(my3rdCenter, 8 * 32, BO && FGT == Protoss_Assimilator).empty()
			&& !GR(my3rdCenter, 8 * 32, FGT == Resource_Vespene_Geyser).empty()) // Assimilator at 3rd
			Warp(Protoss_Assimilator, my3rd);

		bool myScoutFound = false;
		bool trainProbe = true;
		if (C->supplyUsed() >= firstPylonSupply && CL(Protoss_Pylon) == 0
			|| myBO == 1 && C->supplyUsed() >= 18 && CL(Protoss_Gateway) < 2 && C->minerals() < 200
			|| myBO == 3 
			&& (C->supplyUsed() >= 16 && (CL(Protoss_Forge) == 0 && C->minerals() < 200 
				|| enemyRace.compare("_Z") == 0 
				&& (CL(Protoss_Photon_Cannon) < 2 || CL(Protoss_Photon_Cannon) < 2 && CL(Protoss_Probe) >= 15)))
			) trainProbe = false;

		// Manage my units' behaviors...
		UnitType staticDfsType = GetThreatType();
		for (Unit u : C->getUnits()) {
			if (!u->exists() || !u->isCompleted() || u->isMaelstrommed() || u->isStasised() || u->isLoaded() || u->isStuck()) continue;

			if (u->isIrradiated() || u->isUnderStorm()) SmartMove(u, myMainCenter);

			if (hisBO == 31) // Cancel gateway vs 4-pool, *works*?
				if (myBO == 1 && CC(Protoss_Gateway) == 2
					&& L(u) && !u->isCompleted() && u->getBuildType() == Protoss_Gateway
					)
				{
					u->cancelConstruction();
					continue;
				}

			// Closest enemy to this unit within ~ 6 * 32 range
			Unit Z = u GC(BE, 200);
			if (Z && !Z->isMoving()) enemyUnitAndFrameAttackStarted[Z] = currentFrame;
			else if (u->isStartingAttack()) enemyUnitAndFrameAttackStarted[u] = currentFrame;

			
			// Manage Probe Production
			if (Q == Protoss_Nexus) {
				if (!u->isTraining() && trainProbe
					&& CL(Protoss_Probe) < 20 * CC(Protoss_Nexus)) u->train(Protoss_Probe);
			} // if this is Nexus
			
			// Upgrade/Research
			else if (Q == Protoss_Forge) {
				if (myBO == 2 || myBO == 4) { 
					u->upgrade(UpgradeTypes::Protoss_Ground_Weapons); 
					u->upgrade(UpgradeTypes::Protoss_Ground_Armor);
				}
			}
			
			else if (Q == Protoss_Cybernetics_Core) {
				if (myBO == 3) {
					if (C->isUpgrading(UpgradeTypes::Scarab_Damage) || C->getUpgradeLevel(UpgradeTypes::Scarab_Damage))
						u->upgrade(UpgradeTypes::Singularity_Charge);

					if (CL(Protoss_Stargate)) {
						u->upgrade(UpgradeTypes::Protoss_Air_Weapons);
						u->upgrade(UpgradeTypes::Protoss_Air_Armor);
						if (myUnitsCreated[Protoss_Dragoon] >= 2) u->upgrade(UpgradeTypes::Singularity_Charge);
					}
				}
				else if (myBO == 5) {
					if (myUnitsCreated[Protoss_Reaver] >= 2) u->upgrade(UpgradeTypes::Singularity_Charge);
				}
			}

			else if (Q == Protoss_Citadel_of_Adun) {
				if (myBO == 2 || myBO == 4) u->upgrade(UpgradeTypes::Leg_Enhancements);
			}

			else if (Q == Protoss_Robotics_Support_Bay) {
				//if (myBO == 5) u->upgrade(UpgradeTypes::Gravitic_Drive);
				u->upgrade(UpgradeTypes::Scarab_Damage);
			}
			
			else if (Q == Protoss_Observatory) {
				u->upgrade(UpgradeTypes::Gravitic_Boosters);
			}

			// Manage Army Production
			else if (Q == Protoss_Gateway) {
				if (!u->isTraining() && ignoreObs) {
					if (myBO == 1) {
						u->train(Protoss_Zealot);
					}
					else if (myBO == 2 || myBO == 4) {
						if (C->gas() > 50) u->train(Protoss_Dark_Templar);
						else if (myUnitsCreated[Protoss_Dark_Templar])
							u->train(Protoss_Zealot);

						if (CL(Protoss_Cybernetics_Core) && C->minerals() - C->gas() > 225)
							u->train(Protoss_Zealot);
					}
					else if (myBO == 3) {
						if (CL(Protoss_Robotics_Support_Bay) == 0 && C->minerals() > 300
							&& myUnitsCreated[Protoss_Zealot] < 3) u->train(Protoss_Zealot);

						if (CL(Protoss_Nexus) >= 2 || CL(Protoss_Dragoon) < 18 || C->minerals() < 550) {
							if (enemyRace.compare("_Z") == 0) {
								if (myUnitsCreated[Protoss_Corsair] >= 2)
									if (CW(Protoss_Scout) || C->minerals() > 400 && C->gas() > 200)
											u->train(Protoss_Dragoon);
							}
							else {
								if (CL(Protoss_Robotics_Support_Bay) || C->gas() > 250)
									if (CL(Protoss_Reaver) >= 3 || C->minerals() > 325 && C->gas() > 150)
										u->train(Protoss_Dragoon);
							}
						}
					}
					else if (myBO == 5) {
						if (CL(Protoss_Cybernetics_Core) && myUnitsCreated[Protoss_Zealot] == 0) u->train(Protoss_Zealot);
						if (CL(Protoss_Robotics_Facility) && myUnitsCreated[Protoss_Dragoon] < 2
							|| CC(Protoss_Robotics_Support_Bay) 
							&& C->minerals() > (CL(Protoss_Reaver) < 2 ? 325 : 150)
							&& C->gas() > (CL(Protoss_Reaver) < (myUnitsCreated[Protoss_Reaver] <= 2 ? 2 : 1) ? 150 : 50)) 
							u->train(Protoss_Dragoon);
					}
					else if (myBO == 6) {
						if (myUnitsCreated[Protoss_Dragoon] < 2) u->train(Protoss_Dragoon);
						
						bool pumpGatewayUnits = true;
						if (myUnitsCreated[Protoss_Dark_Templar] >= 2 && CL(Protoss_Stargate) == 0
							&& (C->minerals() < 300 || C->gas() < 250)) pumpGatewayUnits = false;

						if (pumpGatewayUnits) {
							if (C->gas() > 40) {
								if (myUnitsCreated[Protoss_Dark_Templar] < 4) u->train(Protoss_Dark_Templar);
								else if (CC(Protoss_Stargate) == 0 || C->minerals() >= 400 || myUnitsCreated[Protoss_Scout] >= 2) {
									u->train(Protoss_Dragoon);
								}
							}
							else if (myUnitsCreated[Protoss_Dark_Templar]) u->train(Protoss_Zealot);
						}
					}
				}
			}

			else if (Q == Protoss_Robotics_Facility) {
				if (!u->isTraining()) {
					if (CL(Protoss_Observer) == 0 && !ignoreObs) u->train(Protoss_Observer);
					if (myBO == 3 && CL(Protoss_Reaver) < 3) u->train(Protoss_Reaver);
					if (myBO == 5) {
						if (//myUnitsCreated[Protoss_Shuttle] < 2 && CL(Protoss_Shuttle) == CL(Protoss_Reaver)
							myUnitsCreated[Protoss_Shuttle] == 0
							) u->train(Protoss_Shuttle);
						if (CL(Protoss_Reaver) < (myUnitsCreated[Protoss_Reaver] <= 2 ? 2 : 1)
							|| CL(Protoss_Reaver) < 2 && CC(Protoss_Nexus) >= 3) u->train(Protoss_Reaver);
					}
				}
			}

			else if (Q == Protoss_Stargate) {
				if (!u->isTraining()) {
					if (myBO == 3) {
						if (myUnitsCreated[Protoss_Corsair] < 2) u->train(Protoss_Corsair);
						else u->train(Protoss_Scout);
						//u->train(Protoss_Scout);
					}
					else if (myBO == 6) {
						if (myUnitsCreated[Protoss_Scout] < 2) u->train(Protoss_Scout);
					}
					if (hisMainKilled && CL(Protoss_Scout) < 4) u->train(Protoss_Scout);
				}
			}
			// ======END OF BUILDINGS=====
			
			// Manage workers...
			else if (Q.isWorker() && (myBuilderID == 0 || u->getID() != myBuilderID)) {
				if (hisBO == 12) { // cannon rush reaction
					if (myBO == 1 ? myUnitsCreated[Protoss_Zealot] < 3 : myUnitsCreated[Protoss_Photon_Cannon] < myMaxCannons) {
						if (myUnitsCreated[Protoss_Probe] - CL(Protoss_Probe) < 2) {
							if (myWatcherID == -99) { myWatcherID = u->getID(); continue; }
							if (myWatcherID2 == -99) { myWatcherID2 = u->getID(); continue; }
						}

						if (u->getID() == myWatcherID || u->getID() == myWatcherID2)
						{
							if (u->isCarryingMinerals() || u->isCarryingGas()) {
								if (u->getLastCommand().getType() != UnitCommandTypes::Return_Cargo) u->returnCargo();
								continue;
							}

							if (Unit hisW = u GC(BE && BW, 32)) {
								SmartAttack(u, hisW);
								continue;
							}

							if (Unit hisBldg = X GC(myMainCenter, BE && (FGT == Protoss_Pylon || FGT == Protoss_Photon_Cannon), 24 * 32)) {
								SmartAttack(u, hisBldg);
								continue;
							}

							if (Unit cm = u GC(BM)) {
								if (u->getLastCommand().getType() != UnitCommandTypes::Gather
									|| u->getLastCommand().getTarget() != cm)
									u->gather(cm);
								continue;
							}
						}
					}
					else {
						if (u->getID() == myWatcherID || u->getID() == myWatcherID2)
						{
							if (Unit cm = u GC(BM)) {
								if (u->getLastCommand().getType() != UnitCommandTypes::Gather
									|| u->getLastCommand().getTarget() != cm)
									u->gather(cm);
								continue;
							}
						}
					}
				} 

				// Send scout when my candidate is found
				if (u->getID() == myScoutID) {
					if (hisMain == TilePositions::None) { myScoutFound = true; GoScouting(u); continue; }
					else {
						if (!u->isGatheringMinerals())
							if (Unit cm = X GC(myMainCenter, BM, 7 * 32))
								if (u->getLastCommand().getType() != UnitCommandTypes::Gather || u->getLastCommand().getTarget() != cm)
								{
									u->gather(cm);
									continue;
								}
					}
				}

				// Set up scouting params
				if (hisMain == TilePositions::None && currentFrame - cs > 240 && !u->isCarryingMinerals() && !u->isCarryingGas()) {
					bool timeToScout = false;
					if (CL(Protoss_Pylon)) timeToScout = true;
					if (myBO == 3 && enemyRace.compare("_Z") == 0 && CL(Protoss_Gateway) == 0) timeToScout = false;

					if (timeToScout) { // When it is time to scout...
						if (myScoutID < 0) { cs = currentFrame; myScoutID = u->getID(); myScoutFound = true; GoScouting(u); continue; }
					}
				}

				if (GR(myMainCenter, 7 * 32, BM).empty() && !u->isUnderAttack()) { // Long-distance mining
					if (!u->isGatheringGas() && !u->isCarryingGas()) {
						if (!u->isGatheringMinerals() && u->isCarryingMinerals()) {
							if (u->getLastCommand().getType() != UnitCommandTypes::Return_Cargo) u->returnCargo();
							continue;
						}

						if (Unit cm = u GC(BM)) {
							if (u->getLastCommand().getType() != UnitCommandTypes::Gather
								|| u->getLastCommand().getTarget() != cm)
								u->gather(cm);
							continue;
						}
					}
				}

				if (Z && (currentFrame - enemyUnitAndFrameAttackStarted[Z]) < 99 && !Z->isFlying() && !u->isGatheringGas() && !u->isCarryingGas()) {
					bool shouldChase = true;
					int hisNearbyWorkers = GR(myMainCenter, 15 * 32, BE && BW).size();
					int hisNearbyAttackers = GR(myMainCenter, 15 * 32, BE && !BW && FCA).size();
					int hisNearbyLings = GR(myMainCenter, 15 * 32, BE && FGT == Zerg_Zergling).size();
					if (hisNearbyWorkers <= 1 && hisNearbyAttackers == 0
						|| DistSq2(Z->getPosition(), myMainCenter) > 225 * 1024
						|| (numStartingLocs < 4 || thisMapIndex == 15) && hisNearbyWorkers >= 2 && hisNearbyAttackers == 0
						|| hisNearbyWorkers == 0 && hisNearbyLings <= 1 && hisNearbyAttackers <= 1
						)
						shouldChase = false;

					// Avoid over-reacting to scouting workers
					if (!shouldChase) {
						if (!Z->isAttacking() && Z->getType().isWorker())
							if (u->getLastCommand().getType() == UnitCommandTypes::Attack_Unit && u->getLastCommand().getTarget() == Z)
								if (Unit cm = X GC(myMainCenter, BM, 7 * 32))
								{
									u->gather(cm);
									continue;
								}

						if (DistSq2(u->getPosition(), myMainCenter) < 225 * 1024)
							if (Z->getType().isWorker() && DistSq2(Z->getPosition(), u->getPosition()) <= 1024)
								if (u->getLastCommand().getType() != UnitCommandTypes::Attack_Unit || u->getLastCommand().getTarget() != Z)
								{
									u->attack(Z);
									continue;
								}
					}

					if (shouldChase) {
						s(u), u->getOrderTarget() != Z ? u->attack(Z) : "a"; // worker defense
						continue;
					}
				}
				else if (CC(Protoss_Assimilator) == 1) { // Dispatch workers on 1st assimilator completion
					int myGasGatherers = count_if(q.begin(), q.end(), [](pair<Unit, Unit> u) { return L(u.second) && u.second->getType() == Protoss_Assimilator; });

					if (myGasGatherers < 3) // Put 3 workers on gas
						if (!u->isGatheringGas() && !u->isCarryingMinerals())
							if (Unit myClosestExtractor = u GC(BO && FGT == Protoss_Assimilator))
								if (u->getLastCommand().getType() != UnitCommandTypes::Right_Click_Unit
									|| u->getLastCommand().getTarget() != myClosestExtractor) {
									if (!q.empty() && q[u] != myClosestExtractor) q[u] = myClosestExtractor;
									u->rightClick(myClosestExtractor);
									continue;
								}

					if (currentFrame % 168 == 0) // Do this every X seconds
						if (u->isIdle() && !u->isMoving())
							if (Unit cm = u GC(BM, 24 * 32))
							{
								u->gather(cm);
								continue;
							}
				}
				else if ((u->getDistance(myNatCenter) < 256 || u->getDistance(my3rdCenter) < 256) && CL(123) > 1) { if (u->isIdle() && !u->isMoving()) if (Unit cm = u GC(BM)) { u->gather(cm); continue; } } // Mining at natural/third
				else if (m.size() && !q.empty() && !q[u]) { // If there is no target resource to gather, find one
					if (u->gather(m[0]))q[u] = m[0], m.erase(m.begin());
				}
				else if (u->getDistance(myMainCenter) < 320) {
					if (!q.empty() && q[u]) {
						if (u->getLastCommand().getType() != UnitCommandTypes::Gather) u->gather(q[u]);
						continue;
					}

					if (u->isIdle() && !u->isMoving()) {
						if (!u->isGatheringGas() && !u->isCarryingGas())
							if (Unit cm = u GC(BM)) { u->gather(cm); continue; }

					}
				} // Refining/Mining at main
			} // workers

			// Manage my army: 
			if (Q == Protoss_Zealot || Q == Protoss_Dragoon || Q == Protoss_Dark_Templar 
				|| Q == Protoss_Corsair || Q == Protoss_Scout
				|| Q == Protoss_Reaver || Q == Protoss_Carrier) {
				if (MeMoveOut()) { 
					if (myBO == 3 && myUnitsCreated[Protoss_Dragoon] < 18 
						&& enemyRace.compare("_Z") && currentFrame % 24 == 0
						&& (Q == Protoss_Dragoon || Q == Protoss_Zealot)) { // Protect reavers
						Position guardPos = myCP;
						if (CC(Protoss_Reaver)) {
							for (Unit u1 : C->getUnits())
								if (L(u1) && u1->isCompleted() && Q == Protoss_Reaver)
									if (Unit closestFoe = u1 GC(BE && FCA, 6 * 32))
									{
										guardPos = u1->getPosition(); break;
									}

							if (guardPos == myCP)
								if (Unit closestReaver = u GC(BO && FGT == Protoss_Reaver))
									guardPos = closestReaver->getPosition();
						}

						if (DistSq2(u->getPosition(), guardPos) > 9 * 1024) {
							SmartMove(u, guardPos);
							continue;
						}
						else {
							if (!u->isHoldingPosition()) u->holdPosition();
							continue;
						}
					} // Protect reavers
					
					if (Q == Protoss_Reaver) {
						if (u->isStartingAttack() || u->isAttackFrame()) continue;

						if (u->getScarabCount() < 5 && !u->isTraining()
							&& C->minerals() > 15 && u->getLastCommand().getType() != UnitCommandTypes::Train) { 
							u->train(Protoss_Scarab); 
							continue; 
						}

						if (u->getScarabCount() == 0 && u->isTraining()) {
							if (u->isMoving() && u->canStop()) u->stop();
							continue;
						}

						if ((myAttackStartedSince == 0 || currentFrame - myAttackStartedSince > 240)
							&& GR(u->getPosition(), 8 * 32, BO && FGT == Protoss_Shuttle).empty()) {
							Position retreatPos = myMainCenter;
							if (hisMain != TilePositions::None && !hisMainKilled)
								if (Unit closestGoon = X GC(hisMainCenter, BO && FGT == Protoss_Dragoon)) retreatPos = closestGoon->getPosition();

							if (retreatPos == myMainCenter)
								if (Unit closestGoon = u GC(BO && FGT == Protoss_Dragoon)) retreatPos = closestGoon->getPosition();

							if (DistSq2(u->getPosition(), retreatPos) > 9 * 1024) {
								SmartMove(u, retreatPos);
								continue;
							}
							else {
								if (!u->isHoldingPosition()) u->holdPosition();
								continue;
							}
						}

						if (Unit closestAttBldg = u GC(BE && FGT == staticDfsType, 11 * 32)) {
							int distToBldg = DistSq2(u->getPosition(), closestAttBldg->getPosition());
							if (distToBldg > 100 * 1024) {
								SmartMove(u, closestAttBldg->getPosition());
								continue;
							}
							else {
								if (currentFrame - u->getLastCommandFrame() >= 2) {
									if (u->isMoving() && u->canStop()) { u->stop(); continue; }

									if (u->canAttack()) {
										UnitCommand lastCmd = u->getLastCommand();
										if (lastCmd.getType() != UnitCommandTypes::Attack_Unit || lastCmd.getTarget() != closestAttBldg)
											u->attack(closestAttBldg);
										continue;
									}
								}
							}
						}

						if (Unit closestFoe = u GC(BE && FCA && !B(Flying) && B(Detected), 10 * 32)) {
							int distToBldg = DistSq2(u->getPosition(), closestFoe->getPosition());
							if (distToBldg > 100 * 1024) {
								SmartMove(u, closestFoe->getPosition());
								continue;
							}

							if (distToBldg <= 81 * 1024 && u->getScarabCount() == 0) {
								SmartMove(u, myMainCenter);
								continue;
							}
							else {
								if (u->getScarabCount()) SmartAttack(u, closestFoe);
								else if (!u->isMoving()) SmartMove(u, myMainCenter);
								continue;
							}
						}

						if (Unit closestFoe2 = u GC(BE && !B(Flying) && B(Detected)
							&& (B(Building) && FGT != staticDfsType || B(Spellcaster)), 10 * 32)) {
							int distToFoe2 = DistSq2(u->getPosition(), closestFoe2->getPosition());
							if (distToFoe2 > 81 * 1024) {
								SmartMove(u, closestFoe2->getPosition());
								continue;
							}
							else {
								if (u->getScarabCount()) SmartAttack(u, closestFoe2);
								else if (!u->holdPosition()) u->holdPosition();
								continue;
							}
						}
					} // if this is a reaver

					if (Q == Protoss_Scout) {
						if (Unit closestAAU = u GC(BE && Filter::AirWeapon != WeaponTypes::None, 320)) {
							SmartAttack(u, closestAAU);
							continue;
						}
					}

					if (Q == Protoss_Dragoon) {
						if (u->isAttackFrame()) continue;

						int thisRange = C->getUpgradeLevel(UpgradeTypes::Singularity_Charge) ? 192 : 128;
						int thisRange2 = thisRange * thisRange;

						if (enemyRace.compare("_T") == 0) // Step up to a tank's blind spot
							if (Unit hisTank = u GC(BE && FCA && B(Sieged), 16 * 32)) {
								Position hisTankPos = hisTank->getPosition();
								if (myAttackStartedSince && currentFrame - myAttackStartedSince < 240)
								{
									int distToTank = DistSq2(u->getPosition(), hisTankPos);
									if (distToTank > thisRange2 || u->getGroundWeaponCooldown()) {
										SmartMove(u, hisTankPos);
										continue;
									}
									else {
										SmartAttack(u, hisTank);
										continue;
									}
								}
							}

						if (Unit hisU = u GC(BE && FCA && Filter::CanMove && !B(Building), thisRange)) {
							double timeToEnter = std::max(0.0, (sqrt(DistSq2(u->getPosition(), hisU->getPosition())) - thisRange) / Q.topSpeed());
							if (timeToEnter < (hisU->isFlying() ? u->getAirWeaponCooldown() : u->getGroundWeaponCooldown()))
							{
								SmartMove(u, myMainCenter);
								continue;
							}
							else {
								SmartAttack(u, hisU);
								continue;
							}
						}
					}

					if (staticDfsType && staticDfsType != UnitTypes::None 
						&& (myBO == 5 || CountHisUnits(staticDfsType))
						&& (Q == Protoss_Zealot || Q == Protoss_Dragoon || Q == Protoss_Dark_Templar)) {
						Position closestThreatPos = Positions::None;
						int minDist2 = 999999999;
						Position uPos = u->getPosition();

						for (auto u1 : hisUnitIDAndInfo) { // must be done PER unit
							UnitType u1Type = u1.second.unitType;
							if (u1Type == staticDfsType
								|| myBO == 5 && !u1Type.isWorker() && !u1Type.isFlyer()
								&& (u1Type.groundWeapon() != WeaponTypes::None || u1Type == Terran_Bunker)) {
								int iDist2 = DistSq2(u1.second.unitPos, uPos);
								if (iDist2 < minDist2) {
									closestThreatPos = u1.second.unitPos;
									minDist2 = iDist2;
								}
							}
						}

						// Stay away from threats!
						if (closestThreatPos != Positions::None && !u->isFlying()
							&& (myAttackStartedSince == 0 || currentFrame - myAttackStartedSince > 240)) {
							Position uPos = u->getPosition();
							
							if (Q == Protoss_Zealot || Q == Protoss_Dark_Templar) {
								if (Unit hisClosest32 = u GC(BE && !B(Flying), 32))
								{
									SmartAttack(u, hisClosest32);
									continue;
								}

								int hisTyp3 = GR(uPos, 9 * 32, BE && FGT == GetThreatType(3)).size();

								if (Unit hisClosestTyp3 = u GC(BE && FGT == GetThreatType(3), 9 * 32))
									if (DistSq2(hisClosestTyp3->getPosition(), closestThreatPos) > 200 * 1024)
										if (5 * hisTyp3 < 4 * static_cast<int>(GR(u->getPosition(), 9 * 32, BO && (FGT == Protoss_Zealot || FGT == Protoss_Dark_Templar)).size()))
											if (DistSq2(uPos, hisClosestTyp3->getPosition()) > 32 * 32) {
												SmartMove(u, hisClosestTyp3->getPosition());
												continue;
											}
											else
											{
												SmartAttack(u, hisClosestTyp3);
												continue;
											}

								if (hisTyp3 > 0 && u->isUnderAttack()) { SmartMove(u, myMainCenter); continue; }
							}

							int u2ThreatDist = DistSq2(uPos, closestThreatPos);
							if (u->isUnderAttack() && u2ThreatDist < 400 * 1024) { SmartMove(u, myMainCenter); continue; }

							if (u2ThreatDist > 163 * 1024 && !u->isUnderAttack()
								&& GR(uPos, 64, BO && !BW && FCA && !B(Flying)).size() >= 3 
								&& u2ThreatDist < (myBO == 5 ? 324 : 290) * 1024) {
								if (!u->isHoldingPosition()) u->holdPosition();
								continue;
							}

							if (u2ThreatDist > 196 * 1024) {
								if (Q == Protoss_Zealot || Q == Protoss_Dark_Templar)
								{
									if (Unit hisU = u GC(BE && FCA && !B(Flying), 32)) {
										SmartAttack(u, hisU);
										continue;
									}
								}

								SmartMove(u, closestThreatPos);
								continue;
							}
							else if (u2ThreatDist < 144 * 1024) {
								Position retreatPos = myMainCenter;
								double deltaX = uPos.x - closestThreatPos.x;
								double deltaY = uPos.y - closestThreatPos.y;
								double uAngle = atan2(deltaY, deltaX);

								int desiredPosX = uPos.x + static_cast<int>(96.0 * cos(uAngle));
								int desiredPosY = uPos.y + static_cast<int>(96.0 * sin(uAngle));

								Position desiredPos = Positions::None;
								if (desiredPosX > 0 && desiredPosX < X->mapWidth() * 32 && desiredPosY > 0 && desiredPosY < X->mapHeight() * 32) {
									desiredPos = Position(desiredPosX, desiredPosY);
									if (3 * sqrt(DistSq2(uPos, desiredPos)) > 2 * BWEB::Map::getGroundDistance(uPos, desiredPos))
										retreatPos = desiredPos;
								}

								SmartMove(u, retreatPos);
								continue;
							}
							else {
								if (!u->isHoldingPosition()) u->holdPosition();
								continue;
							}
						}

						if (Q.groundWeapon() != WeaponTypes::None)
							if (Unit closestBldg = u GC(BE && FGT == staticDfsType, 7 * 32)) {
								if (Q == Protoss_Zealot)
									if (Unit closestU = u GC(BE && FCA && !B(Flying), 32))
									{
										SmartAttack(u, closestU);
										continue;
									}

								SmartAttack(u, closestBldg);
								continue;
							}
					} // if staticDfsType

					// Keal workers faster
					if (Q == Protoss_Zealot || Q == Protoss_Dark_Templar) {
						UnitCommand uLastCmd = u->getLastCommand();
						if (Unit hisClosest = u GC(BE && FCA && B(Detected) && !B(Flying), 32)) {
							if (u->getLastCommandFrame() >= currentFrame - 4)
								if (uLastCmd.getType() != UnitCommandTypes::Attack_Unit || uLastCmd.getTarget() != hisClosest)
								{
									//SmartAttack(u, hisClosestWorker);
									u->attack(hisClosest);
									continue;
								}
						}

						if (uLastCmd.getType() == UnitCommandTypes::Attack_Unit 
							&& uLastCmd.getTarget() && uLastCmd.getTarget() != NULL
							&& uLastCmd.getTarget()->getPosition())
							if (DistSq2(u->getPosition(), uLastCmd.getTarget()->getPosition()) > 32 * 32)
							{
								SmartMove(u, uLastCmd.getTarget()->getPosition());
								continue;
							}
					}
				} // if time to move out
				// <- for all combat units..

				if (hisMain == TilePositions::None) { GoScouting(u); continue; }
				if (hisMainKilled) { // Search and destroy
					if (Unit Z2 = FindTarget(u)) {
						if (L(Z2)) {
							SmartAttack(u, Z2);
							continue;
						}
					}
					else if (Unit Z3 = u GC(BE&&B(Building))) {
						if (Q == Protoss_Zealot && Z3->isFlying()) {
							if (!u->isMoving()) GroundUnitsSearchBases(u);
							continue;
						}

						SmartAttack(u, Z3);
						continue;
					}
					else if (!u->isMoving()) {
						if (Q.isFlyer()) {
							SmartMove(u, Position(rand() % X->mapWidth() * 32, rand() % X->mapHeight() * 32));
							continue;
						}
						else {
							GroundUnitsSearchBases(u);
							continue;
						}
					}
				}
				else { // when enemy starting main is not destroyed..
					Position stagingPos = Positions::None;
					if (myBO == 1 && myUnitsCreated[Protoss_Zealot] < 3) stagingPos = myCP;
					else if ((myBO == 2 || myBO == 4) && myUnitsCreated[Protoss_Dark_Templar] == 0) {
						if (CC(Protoss_Photon_Cannon)) {
							map<int, Position> distAndPos = {};
							for (Unit uc : C->getUnits())
								if (L(uc) && uc->isCompleted() && uc->getType() == Protoss_Pylon)
									distAndPos[DistSq2(uc->getPosition(), myCP)] = uc->getPosition();

							stagingPos = distAndPos.begin()->second;
						}
						else stagingPos = myCP;
					}
					else if (myBO == 3 && enemyRace.compare("_Z") && myUnitsCreated[Protoss_Reaver] == 0) {
						stagingPos = myCP;

						if (CC(Protoss_Pylon)) {
							map<int, Position> distAndPos = {};
							for (Unit uc : C->getUnits())
								if (L(uc) && uc->isCompleted() && uc->getType() == Protoss_Pylon)
									distAndPos[DistSq2(uc->getPosition(), myCP)] = uc->getPosition();

							stagingPos = distAndPos.begin()->second;
						}
					}
					else if (myBO == 5 && myUnitsCreated[Protoss_Reaver] == 0) stagingPos = myCP;

					if (stagingPos && stagingPos != Positions::None) {
						if (DistSq2(u->getPosition(), stagingPos) <= 49 * 1024)
							if (Unit hisU = u GC(BE && FCA, 7 * 32))
							{
								SmartAttack(u, hisU);
								continue;
							}

						if (!u->isFlying())
							if (Unit hisU = u GC(BE && FCA && !B(Flying), u->getType().groundWeapon().maxRange()))
							{
								SmartAttack(u, hisU);
								continue;
							}

						int distToCP2 = DistSq2(u->getPosition(), myCP);
						//X->drawLineMap(u->getPosition(), myCP, Colors::White);
						//X->drawTextMap(u->getPosition(), "%cDist: %.1f", Text::Orange, sqrt(distToCP2) / 32);
						if (distToCP2 > (GR(u->getPosition(), 96, BO && !BW && FCA).size() < 3 ? 9 : 25) * 1024)
							SmartMove(u, myCP);
						else if (!u->isHoldingPosition()) u->holdPosition();
						continue;
					} // staging before moving out

					// Save starting main in danger..
					if (Unit hisClosestAttacker = X GC(myMainCenter, BE && FCA && !BW && !B(Invincible), 640)) {
						if (hisClosestAttacker->isFlying() && Q.airWeapon() != WeaponTypes::None 
							|| !hisClosestAttacker->isFlying() && Q.groundWeapon() != WeaponTypes::None)
						{
							//SmartMove(u, myMainCenter);
							SmartAttack(u, hisClosestAttacker);
							continue;
						}
					}

					if (Unit ZZ = FindTarget(u)) {
						if (L(ZZ)) {
							if (ZZ->getType().isBuilding() && !ZZ->getType().canAttack())
							{
								if (Q.groundWeapon() != WeaponTypes::None && Q.airWeapon() == WeaponTypes::None) {
									if (Unit nearestThreat = u GC(BE && FCA && !B(Flying), 3 * Q.sightRange() / 2))
										ZZ = nearestThreat;
								}
								else if (Q.groundWeapon() == WeaponTypes::None && Q.airWeapon() != WeaponTypes::None) {
									if (Unit nearestThreat = u GC(BE && FCA && B(Flying), 3 * Q.sightRange() / 2))
										ZZ = nearestThreat;
								}
								else if (Q.groundWeapon() != WeaponTypes::None && Q.airWeapon() != WeaponTypes::None) {
									if (Unit nearestThreat = u GC(BE && FCA, 3 * Q.sightRange() / 2))
										ZZ = nearestThreat;
								}
							}

							//X->drawTextMap(u->getPosition(), "%cSmSc: %.2f", Text::Orange, Horizon::getSimValue(u, 240).attackGroundasGround);
							if (MeMoveOut()) SmartAttack(u, ZZ);
							else SmartMove(u, myMainCenter);
							
							continue;
						}
					} // if (Unit ZZ = FindTarget(u))

					if (hisMain != TilePositions::None && !u->isUnderAttack()) {
						// Wait group
						if (Q != Protoss_Reaver && !Q.isFlyer())
							for (auto unitTypeToWait : {Protoss_Zealot, Protoss_Dragoon})
								if (Q == unitTypeToWait && CC(unitTypeToWait) > 1) {
									if (Unit myClosestUnitToHim = X GC(hisMainCenter, BO && FGT == unitTypeToWait, 64 * 32))
										if (static_cast<int>(GR(myClosestUnitToHim->getPosition(), 7 * 32, BO && FGT == unitTypeToWait).size()) < CC(unitTypeToWait) / 2)
										{
											if (u == myClosestUnitToHim) {
												if (!u->isHoldingPosition()) u->holdPosition();
											}
											else SmartMove(u, myClosestUnitToHim->getPosition());
											continue;
										}
								}
						

						if (DistSq2(u->getPosition(), hisMainCenter) <= Q.sightRange() * Q.sightRange() * 1024)
						{
							Unit hisBldg = NULL;
							if (Q.groundWeapon() != WeaponTypes::None && Q.airWeapon() == WeaponTypes::None) {
								if (Unit nearestBldg = u GC(BE && B(Building) && !B(Flying), Q.sightRange()))
									hisBldg = nearestBldg;
							}
							else if (Q.groundWeapon() == WeaponTypes::None && Q.airWeapon() != WeaponTypes::None) {
								if (Unit nearestBldg = u GC(BE && B(Building) && B(Flying), Q.sightRange()))
									hisBldg = nearestBldg;
							}
							else if (Q.groundWeapon() != WeaponTypes::None && Q.airWeapon() != WeaponTypes::None) {
								if (Unit nearestBldg = u GC(BE && B(Building), Q.sightRange()))
									hisBldg = nearestBldg;
							}

							if (hisBldg && hisBldg != NULL) { SmartAttack(u, hisBldg); continue; }
						}
					}

					if (MeMoveOut()) {
						SmartMove(u, hisMainCenter);
					}
					else {
						if (GR(u->getPosition(), 320, BE && FCA).empty() && !u->isUnderAttack())
							SmartMove(u, hisMainCenter);
						else { // retreat + defend bases
							if (myNatBuilt) SmartMove(u, myNatCenter);
							else SmartMove(u, myMainCenter);
						}
					}
				} // when enemy starting main is not destroyed..
			} // Manage my army units

			// Manage auxiliary units
			if (Q == Protoss_Observer) {
				if (u->isUnderAttack()) {
					SmartMove(u, myMainCenter);
					continue;
				}

				Position obsPos = myMainCenter;
				if (hisMain && hisMain != TilePositions::None && !hisMainKilled)
					if (Unit myClosestU = X GC(hisMainCenter, BO && FCA && !BW))
						obsPos = myClosestU->getPosition();

				if (CC(Protoss_Shuttle))
					if (Unit myClosestShuttle = u GC(BO && FGT == Protoss_Shuttle))
						obsPos = myClosestShuttle->getPosition();

				if (DistSq2(u->getPosition(), obsPos) > 4 * 1024)
				{
					SmartMove(u, obsPos);
					continue;
				}
				else {
					if (!u->isHoldingPosition()) u->holdPosition();
					continue;
				}
			}

			if (Q == Protoss_Shuttle) {
				Position uPos = u->getPosition();
				UnitCommand lastCmd = u->getLastCommand();

				// ditch reaver partnership
				if (CountHisUnits(GetThreatType(5)) || CountHisUnits(GetThreatType(6)) || myUnitsCreated[Protoss_Dragoon] >= 8)
				{
					if (!u->getLoadedUnits().empty()) {
						Position unloadPos = myMainCenter;
						if (Unit closestGoon = u GC(BO && FGT == Protoss_Dragoon)) unloadPos = closestGoon->getPosition();

						if (DistSq2(uPos, unloadPos) > 9 * 1024) {
							SmartMove(u, unloadPos);
							continue;
						}
						else {
							if (lastCmd.getType() != UnitCommandTypes::Unload)
								u->unload(u->getLoadedUnits().begin()._Ptr->_Myval);
							continue;
						}
					}
					else {
						if (u->isMoving()) u->move(myMainCenter);
						continue;
					}
				}

				Unit reaverPartner = NULL;
				for (auto u1 : C->getUnits())
					if (L(u1) && u1->isCompleted())
						if (u1->getType() == Protoss_Reaver && shuttleReaverPair[u->getID()] == u1->getID())
						{
							reaverPartner = u1;
							break;
						}

				if (L(reaverPartner)) {
					if (!u->getLoadedUnits().empty() &&
						(u->isUnderAttack() && u->getHitPoints() + u->getShields() < 41 
							|| u->getHitPoints() + u->getShields() < 21)) {
						if (lastCmd.getType() != UnitCommandTypes::Unload) 
							u->unload(u->getLoadedUnits().begin()._Ptr->_Myval);
							
						continue;
					}
					else { // healthy enough to pick up reaver partner...
						if (DistSq2(reaverPartner->getPosition(), myMainCenter) < 576 * 1024
							|| DistSq2(reaverPartner->getPosition(), uPos) < 64 * 1024
							|| reaverPartner->getScarabCount() == 0)
							if (!reaverPartner->isStartingAttack()
								//&& !reaverPartner->isAttackFrame() 
								&& u->getLoadedUnits().empty())
								if (lastCmd.getType() != UnitCommandTypes::Unload
									|| currentFrame - u->getLastCommandFrame() > 16) {
									if (lastCmd.getType() != UnitCommandTypes::Right_Click_Unit
										|| lastCmd.getTarget() != reaverPartner)
										u->rightClick(reaverPartner);
									continue;
								}


						if (DistSq2(reaverPartner->getPosition(), uPos) > 49 * 1024)
							if (!u->isUnderAttack() && u->getLoadedUnits().empty())
							{
								SmartMove(u, reaverPartner->getPosition());
								continue;
							}

						if (hisMain != TilePositions::None && !hisMainKilled) {
							if (!u->getLoadedUnits().empty()) {
								bool shouldUnload = false;
								if (Unit hisThreat = u GC(BE && FCA, 9 * 32)) {
									Position hisThreatPos = hisThreat->getPosition();
									int distToThreat2 = DistSq2(uPos, hisThreatPos);
									if (distToThreat2 <= 49 * 1024) {
										Position retreatPos = Position(uPos.x + int(0.1 * (uPos.x - hisThreatPos.x)),
											uPos.y + int(0.1 * (uPos.y - hisThreatPos.y)));

										TilePosition retreatLoc = TilePosition(retreatPos);
										if (retreatLoc.x > 0 && retreatLoc.x < X->mapWidth() && retreatLoc.y > 0 && retreatLoc.y < X->mapHeight()
											&& X->getGroundHeight(TilePosition(retreatPos)) == X->getGroundHeight(TilePosition(uPos))) {
											SmartMove(u, retreatPos);
											continue;
										}
									}

									int groundDistToThreat = static_cast<int>(BWEB::Map::getGroundDistance(uPos, hisThreatPos));
									if (16 * groundDistToThreat * groundDistToThreat < 25 * distToThreat2)
										shouldUnload = true;
								}

								if (DistSq2(uPos, hisMainCenter) <= 36 * 1024)
									if (Unit hisBase = u GC(BE && BR, 8 * 32))
										shouldUnload = true;

								if (shouldUnload && currentFrame - u->getLastCommandFrame() >= 2)
									if (lastCmd.getType() != UnitCommandTypes::Unload) {
										u->unload(u->getLoadedUnits().begin()._Ptr->_Myval);
										continue;
									}
							}

							Position uNextPos = hisMainCenter;
							TilePosition uTL = TilePosition(uPos);
							bool altPos = false;
							for (int r = 0; r <= 1; ++r) { // check vicinity for threats
								map<int, TilePosition> scoreAndPos;
								for (int i = uTL.x - r; i <= uTL.x + r; ++i)
									for (int j = uTL.y - r; j <= uTL.y + r; ++j)
										if (i > 0 && i < X->mapWidth() && j > 0 && j < X->mapHeight() && gridInfo[i][j]) // Within the map and is good
										{
											altPos = true;
											break;
										}
							}

							if (altPos) {
								TilePosition adjUTL = GetNearestGoodTile(TilePosition(uPos), gridInfo);
								TilePosition uNextTL = runPathSearch(gridInfo, adjUTL, PosToVec(hisMain));
								if (uNextTL && uNextTL != TilePositions::None && uNextTL != TilePosition(0, 0))
									uNextPos = Position(uNextTL);
							}

							/// Visualization
							//X->drawCircleMap(Position(adjUTL), 4, Colors::Purple, true);
							//X->drawLineMap(uPos, Position(adjUTL), Colors::Purple);
							//X->drawCircleMap(uNextPos, 8, Colors::Blue, true);
							//X->drawLineMap(uPos, uNextPos, Colors::Blue);

							if (u->getLastCommand().getType() != UnitCommandTypes::Move
								|| u->getLastCommand().getTargetPosition() != uNextPos)
								u->move(uNextPos);
						} // if his main is found and NOT killed..
					} // if this shuttle is healthy enough
					continue;
				}
				else { // stand by if there is no reaver partner (shuttle)
					Position stagingPos = myMainCenter;
					if (Unit myRobo = u GC(BO && FGT == Protoss_Robotics_Facility))
						stagingPos = myRobo->getPosition();

					if (DistSq2(u->getPosition(), stagingPos) > 4 * 1024)
					{
						SmartMove(u, stagingPos);
						continue;
					}
					else {
						if (!u->isHoldingPosition()) u->holdPosition();
						continue;
					}
				}
			} // if this is a shuttle
		} // for (Unit u : C->getUnits())

		if (!myScoutFound) myScoutID = -99;
	}  // onFrame()

	void onUnitComplete(Unit u) {
		if (u->getPlayer() == X->self()) {
			Q == Protoss_Assimilator ? o(u), o(u) : "a";

			myUnitsCreated[Q]++;
		}
	}

	void onUnitDiscover(Unit u) {
		if (u->getPlayer() == XE) {
			UnitType uType = Q;

			if (uType == Terran_Siege_Tank_Siege_Mode) uType = Terran_Siege_Tank_Tank_Mode;

			if (!uType.isBuilding() || uType == Protoss_Photon_Cannon ||
				uType == Terran_Bunker || uType == Terran_Missile_Turret ||
				uType == Zerg_Sunken_Colony || uType == Zerg_Spore_Colony) {
				hisUnitIDAndInfo[u->getID()].unitType = uType;
				hisUnitIDAndInfo[u->getID()].unitPos = u->getPosition();
				hisUnitIDAndInfo[u->getID()].unitSpd = std::make_pair(u->getVelocityX(), u->getVelocityY());
				hisUnitIDAndInfo[u->getID()].lastFrameVisible = currentFrame;
				hisUnitIDAndInfo[u->getID()].unitEHP = u->getHitPoints() + u->getShields();
			}

			if (uType == Protoss_Dark_Templar 
				//|| uType == Terran_Wraith // iffy
				|| uType == Zerg_Lurker)
				for (static int done = 0; !done++; )
					his1stCloakerFrame = currentFrame;

			hisUnitsCreated[uType]++;
		}
	}

	void onUnitDestroy(Unit u) {
		if (u->getPlayer() == XE) {
			hisDeadUnits[Q]++;
			UnitType uType = Q;
			if (uType == Terran_Siege_Tank_Siege_Mode) uType = Terran_Siege_Tank_Tank_Mode;

			if (!uType.isBuilding() || uType == Protoss_Photon_Cannon ||
				uType == Terran_Bunker || uType == Terran_Missile_Turret ||
				uType == Zerg_Sunken_Colony || uType == Zerg_Spore_Colony) {
				auto it = hisUnitIDAndInfo.find(u->getID());
				if (it != hisUnitIDAndInfo.end())
					hisUnitIDAndInfo.erase(it);
			}
		}
		else if (u->getPlayer() == C) {
			if (Q == Protoss_Probe) {
				if (u->getID() == myWatcherID) myWatcherID = -99;
				if (u->getID() == myWatcherID2) myWatcherID2 = -99;
				if (u->getID() == myBuilderID) myBuilderID = -99;
			}
		}
	}

	void onEnd(bool u) {
		// 1st File to Write
		ostringstream mfo;

		for (int ki = 0; ki < myBOStatsSize - 1; ++ki) { // Reserve the last X slots
			if (ki % 2 == 0 && ki / 2 + 1 == myBO || ki % 2 && (ki + 1) / 2 == myBO && u) myBOStats[ki]++;
			mfo << myBOStats[ki] << "\n";
		}
		mfo << his1stCloakerFrame << "\n";

		ofstream mf("bwapi-data/write/" + enemyName + enemyRace + ".txt", ofstream::trunc);
		if (mf)
		{
			mf << mfo.str();
			mf.flush();
		}
		mf.close();

		// 2nd File to Write
		ostringstream mfo2;
		for (auto i : hisInfo)
			mfo2 << i << "\n";

		ofstream mf2("bwapi-data/write/" + enemyName + enemyRace + "_INFO" + ".txt", ofstream::trunc);
		if (mf2)
		{
			mf2 << mfo2.str();
			mf2.flush();
		}
		mf2.close();

		// 3rd File to Write
		ostringstream mfo3;
		for (int i = 1; i < numMyRecentStats; ++i)
			mfo3 << myRecentStats[i] << "\n";

		mfo3 << hisBO * 100 + myBO * 10 + u << "\n";

		ofstream mf3("bwapi-data/write/" + enemyName + enemyRace + "_RECENT" + ".txt", ofstream::trunc);
		if (mf3)
		{
			mf3 << mfo3.str();
			mf3.flush();
		}
		mf3.close();
	}
};
